% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{restricted_OLS_c}
\alias{restricted_OLS_c}
\title{Fast least squares with linear constraint}
\usage{
restricted_OLS_c(y, X, bhat, Q, c)
}
\arguments{
\item{y}{Vector of outcomes.}

\item{X}{Matrix of covariates (first column should be 1's)}

\item{bhat}{Unconstrained OLS-fitted coefficients.}

\item{Q}{Matrix of linear constraints (k x p).}

\item{c}{Vector of constraint values (k x 1).}
}
\value{
Vector of fitted OLS coefficients under linear constraint.
}
\description{
This functions fits the regression y ~ X under a linear constraint on the
model parameters. The constraint is  \code{Q} * beta = \code{c} where beta
are the regression model parameters, and \code{Q, c} are inputs.
}
\seealso{
Advanced Econometrics (Section 1.4, Takeshi Amemiya, 1985)
}
