% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{pass_args}
\alias{pass_args}
\title{Specifying QGIS geoalgorithm parameters the R way}
\usage{
pass_args(alg, ..., params = NULL, qgis_env = set_env())
}
\arguments{
\item{alg}{The name of the geoalgorithm to use.}

\item{...}{Triple dots can be used to specify QGIS geoalgorithm arguments as
R named arguments.}

\item{params}{Parameter-argument list for a specific geoalgorithm, see
\code{\link[=get_args_man]{get_args_man()}} for more details. Please note that you can either specify
R arguments directly via the triple dots (see above) or via the
parameter-argument list. However, you may not mix the two methods.}

\item{qgis_env}{Environment containing all the paths to run the QGIS API. For
more information, refer to \code{\link[=set_env]{set_env()}}.}
}
\value{
The function returns the complete parameter-argument list for a given
QGIS geoalgorithm. The list is constructed with the help of
\code{\link[=get_args_man]{get_args_man()}} while considering the R named arguments or the
\code{params}-parameter specified by the user as additional input. If available,
the function returns the default values for all parameters which were not
specified.
}
\description{
The function lets the user specify QGIS geoalgorithm parameters
as R named arguments or a a parameter-argument list. When omitting required
parameters, defaults will be used if available as derived from
\code{\link[=get_args_man]{get_args_man()}}. Additionally, the function checks thoroughly the
user-provided parameters and arguments.
}
\details{
In detail, the function performs following actions and
parameter-argument checks:
\itemize{
\item Were the right parameter names used?
\item Were the correct argument values provided?
\item The function collects all necessary arguments (to run QGIS) and
respective default values which were not set by the user with the help of
\code{\link[=get_args_man]{get_args_man()}}.
\item If an argument value corresponds to a spatial object residing in R
(\code{sp}-, \code{sf}- or \code{raster}-objects are supported), the function will save
the spatial object to a temporary folder, and use the corresponding file
path to replace the spatial object in the parameter-argument list. If the
QGIS geoalgorithm parameter belongs to the
\code{ParameterMultipleInput}-instance class (see for example
\code{get_usage(grass7:v.patch)}) you may either use a character-string
containing the paths to the spatial objects separated by a semi-colon
(e.g., "shape1.shp;shape2.shp;shape3.shp" - see also \href{https://docs.qgis.org/2.8/en/docs/user_manual/processing/console.html}{QGISdocumentation})
or provide a \code{\link[base:list]{base::list()}} containing the spatial objects.
\item If the user only specified the name of an output file (e.g.
"slope.asc") and not a complete path, the function will save the output in
the temporary folder, i.e. to \code{file.path(tempdir(), "slope.asc")}.
\item If a parameter accepts as arguments values from a selection, the
function replaces verbal input by the corresponding number (required by the
QGIS Python API). Please refer to the example section for more details, and
to \code{\link[=get_options]{get_options()}} for valid options for a given geoalgorithm.
\item If \code{GRASS_REGION_PARAMETER} is "None" (the QGIS default), \code{run_qgis}
will automatically determine the region extent based on the user-specified
input layers. If you do want to specify the \code{GRASS_REGION_PARAMETER}
yourself, please do it in accordance with the \href{https://docs.qgis.org/2.8/en/docs/user_manual/processing/console.html}{QGISdocumentation},
i.e., use a character string and separate the coordinates with a comma:
"xmin, xmax, ymin, ymax".
}
}
\note{
The function was inspired by \code{\link[rgrass7:doGRASS]{rgrass7::doGRASS()}}.
}
\examples{
\dontrun{
data(dem, package = "RQGIS")
alg <- "grass7:r.slope.aspect"
get_usage(alg)
# 1. using R named arguments
pass_args(alg, elevation = dem, slope = "slope.asc")
# 2. doing the same with a parameter argument list
pass_args(alg, params = list(elevation = dem, slope = "slope.asc"))
# 3. verbal input replacement (note that "degrees" will be replaced by 0)
get_options(alg)
pass_args(alg, elevation = dem, format = "degrees")
}
}
\author{
Jannes Muenchow
}
