% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.dummy.tables.R
\name{dummy_tables}
\alias{dummy_tables}
\alias{create_primitive_arrays_table}
\alias{create_primitive_maps_table}
\alias{create_primitive_types_table}
\alias{create_primitive_rows_table}
\alias{create_array_of_rows_table}
\alias{create_array_of_maps_table}
\title{Create dummy tables in Presto for testing}
\usage{
create_primitive_arrays_table(
  con,
  table_name = "presto_primitive_arrays",
  time_zone = "America/New_York",
  verbose = TRUE
)

create_primitive_maps_table(
  con,
  table_name = "presto_primitive_maps",
  time_zone = "America/New_York",
  verbose = TRUE
)

create_primitive_types_table(
  con,
  table_name = "presto_primitive_types",
  time_zone = "America/New_York",
  verbose = TRUE
)

create_primitive_rows_table(
  con,
  table_name = "presto_primitive_rows",
  time_zone = "America/New_York",
  verbose = TRUE
)

create_array_of_rows_table(
  con,
  table_name = "presto_array_of_rows",
  time_zone = "America/New_York",
  verbose = TRUE
)

create_array_of_maps_table(
  con,
  table_name = "presto_array_of_maps",
  time_zone = "America/New_York",
  verbose = TRUE
)
}
\arguments{
\item{con}{A valid \code{PrestoConnection} object.}

\item{table_name}{The resulting table name.}

\item{time_zone}{Time zone string for data types that require a time zone.
Default to "America/New_York".}

\item{verbose}{Boolean indicating whether messages should be printed. Default
to TRUE.}
}
\description{
\code{\link[=create_primitive_arrays_table]{create_primitive_arrays_table()}} creates a dummy
table that has ARRAYs of primitive Presto data types.

\code{\link[=create_primitive_maps_table]{create_primitive_maps_table()}} creates a dummy table that has
MAPs of primitive Presto data types.

\code{\link[=create_primitive_types_table]{create_primitive_types_table()}} creates a dummy table that has
primitive Presto data types.

\code{\link[=create_primitive_rows_table]{create_primitive_rows_table()}} creates a dummy table that has all primitive
data types included in one \code{ROW} type column.

\code{\link[=create_array_of_rows_table]{create_array_of_rows_table()}} creates a dummy table that has an \code{ARRAY(ROW)}
column that has 2 \code{ROW} elements, each containing all 17 supported primitive
data types.

\code{\link[=create_array_of_maps_table]{create_array_of_maps_table()}} creates a dummy table that has 17 \code{ARRAY(MAP)}
columns, each of which has an \code{ARRAY} of 2 \code{MAP} elements.
}
\details{
We construct the \strong{arrays-of-primitive-types} table by putting two different
values of the same type and a NULL value in an array. In this way, the three
values of the same type appear together in the source code and therefore are
easier to compare. For integer values, we use the theoretical lower bound
(i.e., minimum value) and the theoretical upper bound (i.e., maximum value)
as the two values. The field names are taken from the Presto data types they
represent.

Here's the complete primitive type values included in the table\tabular{llll}{
   Index \tab Column \tab Type \tab ARRAY values \cr
   1 \tab boolean \tab BOOLEAN \tab [true, false, null] \cr
   2 \tab tinyint \tab TINYINT \tab [-128, 127, null] \cr
   3 \tab smallint \tab SMALLINT \tab [-32768, 32767, null] \cr
   4 \tab integer \tab INTEGER \tab [-2147483647, 2147483647, null] \cr
   5 \tab bigint \tab BIGINT \tab [-9007199254740991, 9007199254740991, null] \cr
   6 \tab real \tab REAL \tab [1.0, 2.0, null] \cr
   7 \tab double \tab DOUBLE \tab [1.0, 2.0, null] \cr
   8 \tab decimal \tab DECIMAL \tab [-9007199254740991.5, 9007199254740991.5, null] \cr
   9 \tab varchar \tab VARCHAR \tab ['abc', 'def', null] \cr
   10 \tab char \tab CHAR \tab ['a', 'b', null] \cr
   11 \tab varbinary \tab VARBINARY \tab ['abc', 'def', null] \cr
   12 \tab date \tab DATE \tab ['2000-01-01', '2000-01-02', null] \cr
   13 \tab time \tab TIME \tab ['01:02:03.456', '02:03:04.567', null] \cr
   14 \tab time_with_tz \tab TIME WITH TIME ZONE \tab ['01:02:03.456 \<tz\>', '02:03:04.567 \<tz\>', null] \cr
   15 \tab timestamp \tab TIMESTAMP \tab ['2000-01-01 01:02:03.456', '2000-01-02 02:03:04.567', null] \cr
   16 \tab timestamp_with_tz \tab TIMESTAMP WITH TIME ZONE \tab ['2000-01-01 01:02:03.456 \<tz\>', '2000-01-02 02:03:04.567 \<tz\>', null] \cr
   17 \tab interval_year_to_month \tab INTERVAL YEAR TO MONTH \tab ['14' MONTH, '28' MONTH, null] \cr
   18 \tab interval_day_to_second \tab INTERVAL DAY TO SECOND \tab ['2 4:5:6.500' DAY TO SECOND, '3 7:8:9.600' DAY TO SECOND, null] \cr
}

We construct the \strong{maps-of-primitive-types} table by first creating a table
with ARRAYs of all primitive data types. We then use the MAP() function to
create the MAPs from ARRAYs.

We construct the \strong{primitive-types} table by first creating a table with
ARRAYs of all primitive data types. We then use Presto's UNNEST() function to
expand the arrays into three separate rows. Each supported Presto data type
has three rows in the table so that the resulting R data frame is distinctly
different from a simple named list.

We construct the \strong{primitive-rows} table by first creating a table with
all primitive data types. We then use Presto's \verb{CAST(ROW() AS ROW())}
function to create the \code{ROW} column.

We construct the \strong{array-of-rows} table by first creating a table with
a \code{ROW} type column that includes all 17 supported primitive data types. We
then use the \code{ARRAY[]} function to construct the 2-element \code{ARRAY(ROW)}
column.

We construct the \strong{array-of-maps} table by first creating a table a
primitive \code{MAP} table and then calling the \code{ARRAY[]} function to create the
\code{ARRAY(MAP)} columns.
}
\keyword{internal}
