% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robgit_RPS.R
\docType{package}
\name{'RPS'}
\alias{'RPS'}
\alias{robgit_RPS}
\alias{'RPS'-package}
\title{Resistant Procrustes Superposition Package in R (RPS):
a novel package for landmark-based resistant shape analysis}
\usage{
robgit_RPS(X, consenso = FALSE)
}
\arguments{
\item{X}{A s-dimensional array of n x k matrices (k configurations of n landmarks), each representing the shape of an object}

\item{consenso}{A logical value that determines if the consensus configuration is returned.}
}
\value{
s-dimensional array of n x k matrices, representing the (resistant) superimposed objects
}
\description{
RPS provides a set of tools to perform a rather complete descriptive
landmark-based resistant shape analysis 3D and 2D, following Torcida
et al. 2014 ("An integrated approach for landmark-based resistant shape analysis
   in 3D", Evol. Biol. 41(2):351_366). More specifically, these tools enable to
obtain: i) a generalized resistant Procrustes superposition (robgit_RPS.R) for
a set of configurations of landmarks either in 3D and 2D; ii) a resistant
distance (resdistance_RPS.R) to quantify shape differences obtained following
the resistant Procrustes superimposition, and iii) a resistant ordination
(resunivMDS_RPS.R) of the superimposed configurations based on the universal
Multidimensional Scaling from (Agarwal et al. 2010). The corresponding least
squares (LS) counterparts of all these tools (procrustesCM_RPS.R,
cmdistance_RPS.R and eucunivMDS_RPS.R, respectively) have also been implemented
in RPS_R to offer a more complete set of shape analysis descriptive tools. This
enables the comparison of the LS and resistant superimposition results when
applied to the same dataset. Also included is a rather new method for a
resistant analysis of individual shape asymmetry for configurations of
landmarks in 2D with bilateral symmetry (matching or object symmetry), following
Torcida et al. 2016 ("A resistant method for landmark-based analysis of
individual asymmetry in two dimensions",Quant. Biol. 4(4):270_282). The main
tools enable to estimate the resistant symmetric shape under matching symmetry
(matchingsymm_RPS.R) adn the resistant symmetric shape estimation under object
symmetry (objectsymm_RPS.R). In both cases, a plot of the results and the table
sof landmarks contributions to asymmetry are also offered.
}
\section{Functions}{

eucunivMDS_RPS, resunivMDS_RPS, cmdistance_RPS, resdistance_RPS, readlandtxtMorphJ_RPS, robgit_RPS,matchingsymm_RPS,objectsymm_RPS, procrustesCM_RPS
}

\examples{
source = array(matrix(nrow = 8,ncol = 3),c(8,3,3),dimnames = NULL)
source[,,1] <- matrix(c(3,0,0,3,0,1,3,1,1,3,1,0,0,0,0,0,0,1,0,1,1,0,1,0)
                   ,nrow = 8,ncol = 3,byrow = TRUE)
source[,,2] <- matrix(c(3, 0 ,0,3, 0, 0.5,3, 1 ,0.75,3 ,1 ,0,0 ,0 ,0,0, 0 ,1,0, 1, 1,0, 1, 0.25)
                     ,nrow = 8,ncol = 3,byrow = TRUE)
source[,,3] <- matrix(c(5, 2 ,1,3, 0, 1.5,3.4, 1 ,1.75,3 ,1 ,0,0 ,0 ,0,0, 2 ,1,0, 3, 1,0, 1, 0.75)
                     ,nrow = 8,ncol = 3,byrow = TRUE)
result <- RPS::robgit_RPS(source, consenso = FALSE)
result

}
\author{
Guillermo Pacheco, Viviana Ferraggine, Sebastian Torcida
}
