% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printSE.R
\name{printSE}
\alias{printSE}
\title{Formatted Output for Standard Errors Functions in RPESE}
\usage{
printSE(SE.data, round.digit = 3, round.out = TRUE)
}
\arguments{
\item{SE.data}{Standard error estimates output from RPESE functions.}

\item{round.digit}{Number of digits for rounding.}

\item{round.out}{Round data (TRUE) with round.digit number of digits. Default is TRUE.}
}
\value{
A data frame with formatted output from standard error functions from \code{RPESE}.
}
\description{
\code{printSE} returns a formatted output from standard error functions from RPESE.
}
\examples{
# Loading data
data(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Computing the standard errors for
# the two influence functions based approaches
ES.out <- ES.SE(edhec, se.method = c("IFiid","IFcor"),
                cleanOutliers = FALSE,
                fitting.method = c("Exponential", "Gamma")[1])
# Print the output
printSE(ES.out)

}
\author{
Xin Chen, \email{chenx26@uw.edu}

Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
