% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmegaRatio_SE.R
\name{OmegaRatio.SE}
\alias{OmegaRatio.SE}
\title{Standard Error Estimate for Omega Ratio of Returns}
\usage{
OmegaRatio.SE(
  data,
  const = 0,
  k = 4,
  se.method = c("IFiid", "IFcor", "IFcorAdapt", "IFcorPW", "BOOTiid", "BOOTcor")[c(1,
    3)],
  cleanOutliers = FALSE,
  fitting.method = c("Exponential", "Gamma")[1],
  d.GLM.EN = 5,
  freq.include = c("All", "Decimate", "Truncate")[1],
  freq.par = 0.5,
  ...
)
}
\arguments{
\item{data}{Data of returns for one or multiple assets or portfolios.}

\item{const}{Constant threshold.}

\item{k}{Range parameter for the shape of the IF (the SD gets multiplied k times).}

\item{se.method}{A character string indicating which method should be used to compute
the standard error of the estimated standard deviation. One or a combination of:
\code{"IFiid"} (default), \code{"IFcor"}, \code{"IFcorPW"}, \code{"IFcorAdapt"} (default),
\code{"BOOTiid"}, \code{"BOOTcor"}.}

\item{cleanOutliers}{Boolean variable to indicate whether the pre-whitenning of the influence functions TS should be done through a robust filter.}

\item{fitting.method}{Distribution used in the standard errors computation. Should be one of "Exponential" (default) or "Gamma".}

\item{d.GLM.EN}{Order of the polynomial for the Exponential or Gamma fitting. Default polynomial order of 5.}

\item{freq.include}{Frequency domain inclusion criteria. Must be one of "All" (default), "Decimate" or "Truncate."}

\item{freq.par}{Percentage of the frequency used if \code{"freq.include"} is "Decimate" or "Truncate." Default is 0.5.}

\item{...}{Additional parameters.}
}
\value{
A vector or a list depending on \code{se.method}.
}
\description{
\code{OmegaRatio.SE} computes the standard error of the Omega ratio of the returns.
}
\examples{
# Loading data from PerformanceAnalytics
data(edhec, package = "PerformanceAnalytics")
class(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Computing the standard errors for
# the two influence functions based approaches
OmegaRatio.SE(edhec, se.method=c("IFiid","IFcorAdapt")[1],
              cleanOutliers=FALSE,
              fitting.method=c("Exponential", "Gamma")[1])

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
