% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.AbstractDist.R
\name{AbstractDist}
\alias{AbstractDist}
\title{AbstractDist}
\description{
Base class for OOP statistical distribution
}
\details{
This class is only used to be herited
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ddist}}{[function] density function}

\item{\code{pdist}}{[function] distribution function}

\item{\code{qdist}}{[function] quantile function}

\item{\code{rdist}}{[function] random generator function}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{[string] name of the distribution}

\item{\code{opt}}{[stats::optim result] Result of the MLE to find parameters}

\item{\code{cov}}{[matrix] Covariance matrix of parameters, inverse of hessian}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AbstractDist$new()}}
\item \href{#method-rvs}{\code{AbstractDist$rvs()}}
\item \href{#method-density}{\code{AbstractDist$density()}}
\item \href{#method-logdensity}{\code{AbstractDist$logdensity()}}
\item \href{#method-cdf}{\code{AbstractDist$cdf()}}
\item \href{#method-sf}{\code{AbstractDist$sf()}}
\item \href{#method-icdf}{\code{AbstractDist$icdf()}}
\item \href{#method-isf}{\code{AbstractDist$isf()}}
\item \href{#method-fit}{\code{AbstractDist$fit()}}
\item \href{#method-clone}{\code{AbstractDist$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new AbstractDist object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$new(ddist, pdist, qdist, rdist, name, has_gr_nlll)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ddist}}{[function] Density function, e.g. dnorm}

\item{\code{pdist}}{[function] Distribution function, e.g. pnorm}

\item{\code{qdist}}{[function] Quantile function, e.g. qnorm}

\item{\code{rdist}}{[function] Random generator function, e.g. rnorm}

\item{\code{name}}{[str]      name of the distribution}

\item{\code{has_gr_nlll}}{[bool] If the derived class has defined the gradient
of the negative log-likelihood}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `AbstractDist` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rvs"></a>}}
\if{latex}{\out{\hypertarget{method-rvs}{}}}
\subsection{Method \code{rvs()}}{
Generation sample from the histogram
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$rvs(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{[integer] Number of samples drawn}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] A vector of samples
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-density"></a>}}
\if{latex}{\out{\hypertarget{method-density}{}}}
\subsection{Method \code{density()}}{
Density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$density(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logdensity"></a>}}
\if{latex}{\out{\hypertarget{method-logdensity}{}}}
\subsection{Method \code{logdensity()}}{
Log density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$logdensity(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the log-density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] log of density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-cdf}{}}}
\subsection{Method \code{cdf()}}{
Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$cdf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] cdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sf"></a>}}
\if{latex}{\out{\hypertarget{method-sf}{}}}
\subsection{Method \code{sf()}}{
Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$sf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] sf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-icdf"></a>}}
\if{latex}{\out{\hypertarget{method-icdf}{}}}
\subsection{Method \code{icdf()}}{
Inverse of Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$icdf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] icdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isf"></a>}}
\if{latex}{\out{\hypertarget{method-isf}{}}}
\subsection{Method \code{isf()}}{
Inverse of Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$isf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] isf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Fit method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$fit(Y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{[vector] Dataset to infer the histogram}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`self`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
