% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{equal}
\alias{equal}
\alias{equal.NULL}
\alias{equal.logical}
\alias{equal.integer}
\alias{equal.numeric}
\alias{equal.character}
\alias{equal.list}
\alias{equal.simple_triplet_matrix}
\alias{equal.L_constraint}
\alias{equal.Q_constraint}
\alias{equal.V_bound}
\title{Compare two Objects}
\usage{
equal(x, y, ...)

\method{equal}{`NULL`}(x, y, ...)

\method{equal}{logical}(x, y, ...)

\method{equal}{integer}(x, y, ...)

\method{equal}{numeric}(x, y, ...)

\method{equal}{character}(x, y, ...)

\method{equal}{list}(x, y, ...)

\method{equal}{simple_triplet_matrix}(x, y, ...)

\method{equal}{L_constraint}(x, y, ...)

\method{equal}{Q_constraint}(x, y, ...)

\method{equal}{V_bound}(x, y, ...)
}
\arguments{
\item{x}{an \R object to be compared with object y.}

\item{y}{an \R object to be compared with object x.}

\item{...}{optional arguments to \code{equal}.}
}
\value{
\code{TRUE} if \code{x} and \code{y} are equal \code{FALSE} otherwise.
}
\description{
The utility function \code{equal} can be used to compare two
  \pkg{ROI} objects and is mainly used for testing purposes.
}
\examples{
## compare numeric values
equal(1e-4, 1e-5, tol=1e-3)
## L_constraint
lc1 <- L_constraint(diag(1), dir=c("=="), rhs=1)
lc2 <- L_constraint(diag(2), dir=c("==", "<="), rhs=1:2)
equal(lc1, lc1)
equal(lc1, lc2)
}
