% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OINT.R
\name{BootCorr}
\alias{BootCorr}
\title{Bootstrap Correlation Estimate.}
\usage{
BootCorr(y, G, X, k = 3/8, B = 100, parallel = F)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by snp genotype matrix.}

\item{X}{Model matrix of covariates.}

\item{k}{Offset applied during rank-normalization.}

\item{B}{Bootstrap samples for correlation estimation.}

\item{parallel}{Run bootstraps in parallel? Must register parallel backend first.}
}
\value{
Numeric matrix of correlation estimates, one per column of \code{G}.
}
\description{
Estimates the correlation between correlated p-values on the Z-score scale.
Avoids the assumption that the correlation between p-values is constant across
loci. Instead, bootstrap is used to calculate a locus-specific estimate.
}
