% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{rankNormal}
\alias{rankNormal}
\title{Rank-Normalize}
\usage{
rankNormal(u, c = 3/8)
}
\arguments{
\item{u}{Numeric vector.}

\item{c}{Offset. Defaults to (3/8), correspond to the Blom transform.}
}
\value{
Numeric vector of rank normalized measurements.
}
\description{
Applies the rank based inverse normal transform (INT) to a numeric vector.
INT is indicated for continuous phenotypes lacking ties. See the vignette for
the mathematical definition of INT.
}
\examples{
# Draw from chi-1 distribution
y = rchisq(n=1000,df=1);
# Rank normalize
z = RNOmni::rankNormal(y);
# Plot density of transformed measurement
plot(density(z));
}
