% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{PIINT}
\alias{PIINT}
\title{Partially Indirect-INT}
\usage{
PIINT(y, G, X, S, M = T, c = 3/8)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Snp by obs genotype matrix.}

\item{X}{Obs by feature covariate matrix.}

\item{S}{Obs by feature structure matrix.}

\item{M}{Apply missingness filter? See \code{\link{missFilter}}.}

\item{c}{Offset applied during rank-normalization. See \code{\link{rankNormal}}.}
}
\value{
A numeric vector of p-values assessing the null hypothesis of no 
  genotypic effect. P-values are estimated using the Wald statistic, and 
  correspond to the rows of G.
}
\description{
Two-stage regression procedure. In the first stage, phenotype is regressed on
covariates to obtain residuals. In the second stage, INT-transformed
residuals are regressed on genotype and adjustments for population structure.
}
\examples{
# PIINT against normal phenotype
p = RNOmni::PIINT(y=RNOmni::Y[,1],G=RNOmni::G[1:10,],X=RNOmni::X,S=RNOmni::S);
}
