% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{filter_genes}
\alias{filter_genes}
\title{Filter genes with low counts}
\usage{
filter_genes(dds, min_count = 5, min_rep = 3)
}
\arguments{
\item{dds}{A DESeqDataSet}

\item{min_count, min_rep}{keep genes with at least min_count counts in at least min_rep replicates}
}
\value{
A \code{DESeq2::DESeqDataSet} object with only those genes that meet the filter criteria.
}
\description{
Filter genes with low counts
}
\examples{
library("DESeq2")
dds <- makeExampleDESeqDataSet()
filter_genes(dds)

}
