% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/donors.R
\name{chooseSigma}
\alias{chooseSigma}
\title{Select the threshold sigma for hd-MI.}
\usage{
chooseSigma(X, Y, sigma_list, seed = NULL)
}
\arguments{
\item{X}{n x p numeric matrix containing RNA-seq expression with missing rows
(numeric matrix or data frame)}

\item{Y}{auxiliary dataset (n' x q numeric matrix or data frame)}

\item{sigma_list}{a sequence of increasing positive values for sigma (numeric
vector)}

\item{seed}{single value, interpreted as an in integer, used to initialize
the random number generation state}
}
\value{
a data frame with the values of sigma and the corresponding
intra-donor pool variances
}
\description{
\code{chooseSigma} computes the average intra-donor pool variance for
different values of sigma. It helps choosing a sigma that makes a good
trade-off between homogeneity within the pool of donors and variety (large
enough number of donors in every pool).
}
\details{
The average intra-donor pool variance is described in (Imbert
\emph{et al.}, 2017).
}
\examples{
data(lung)
data(thyroid)
nobs <- nrow(lung)
miss_ind <- sample(1:nobs, round(0.2 * nobs), replace = FALSE)
lung[miss_ind, ] <- NA
lung <- na.omit(lung)
sigma_stats <- chooseSigma(lung, thyroid, 1:5)
\dontrun{plot(sigma_stats, type = "b")}

}
\author{
{Alyssa Imbert, \email{alyssa.imbert@inra.fr}

Nathalie Villa-Vialaneix, \email{nathalie.villa-vialaneix@inra.fr}}
}
\references{
{Imbert, A., Le Gall, C., Armenise, C., Lefebvre, G., Hager, J.,
Valsesia, A., Gourraud, P.A., Viguerie, N. and Villa-Vialaneix, N. (2017)
Multiple hot-deck imputation for network inference from RNA sequencing data.
\emph{Preprint}.}
}
\seealso{
\code{\link{varIntra}}
}

