\name{salamander}
\alias{salamander}
\docType{data}
\title{ Salamander occupancy data}
\description{
An occupancy data set for modelling presence/absence data for salamanders.
}
\usage{data(salamander)}
\format{
  A data frame with 39 observations (sites) on the following 2 variables.
  \describe{
    \item{ch}{a character vector containing the presence (1) and absence (0) for each visit to the site}
    \item{freq}{frequency of sites (always 1)}
  }
}
\details{
This is a data set that accompanies program PRESENCE and is explained on page 99 of MacKenzie et al. (2006).
}

\examples{
do.salamander=function()
{
   data(salamander)
   occ.p.dot=mark(salamander,model="Occupancy")
   occ.p.time=mark(salamander,model="Occupancy",
         model.parameters=list(p=list(formula=~time)))
   occ.p.mixture=mark(salamander,model="OccupHet",
         model.parameters=list(p=list(formula=~mixture)))
   return(collect.models())
}
salamander.results=do.salamander()
print(salamander.results)
}
\references{ MacKenzie, D.I., Nichols, J. D., Royle, J.A., Pollock, K.H., Bailey, L.L., and Hines, J.E.  2006.
Occupancy Estimation and Modeling: Inferring Patterns and Dynamics of Species Occurence. Elsevier, Inc. 324p.}

\keyword{datasets}
