/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import weka.gui.GenericObjectEditor;
import weka.gui.ensembleLibraryEditor.tree.GenericObjectNode;

public class GenericObjectNodeEditor
extends JPanel
implements PropertyChangeListener,
ActionListener,
PopupMenuListener {
    private static final long serialVersionUID = -2382339640932830323L;
    private GenericObjectEditor m_GenericObjectEditor;
    private JLabel m_Label;
    private JButton m_ChooseClassButton;
    private JButton m_MoreInfoButton;
    private JFrame m_HelpFrame;
    private PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);
    private Color textForeground;
    private Color textBackground;
    private GenericObjectNode m_Node;
    private JPopupMenu m_popup;

    public GenericObjectNodeEditor(GenericObjectNode genericObjectNode) {
        this.m_GenericObjectEditor = genericObjectNode.getEditor();
        this.m_GenericObjectEditor.setValue(genericObjectNode.getObject());
        this.m_GenericObjectEditor.addPropertyChangeListener(genericObjectNode);
        this.m_GenericObjectEditor.addPropertyChangeListener(this);
        this.m_Node = genericObjectNode;
        this.updateEditor();
    }

    public void updateEditor() {
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
        this.setForeground(this.textForeground);
        this.setBackground(this.textBackground);
        this.m_ChooseClassButton = new JButton("Choose");
        this.m_ChooseClassButton.addActionListener(this);
        this.m_ChooseClassButton.setForeground(this.textForeground);
        this.m_ChooseClassButton.setBackground(this.textBackground);
        Font font = UIManager.getFont("Tree.font");
        String string = null;
        boolean bl = false;
        String string2 = this.m_Node.getObject().getClass().toString();
        if (string2.length() > 23 && string2.substring(0, 23).equals("class weka.classifiers.")) {
            bl = true;
        }
        string = bl ? new String(this.m_Node.getObject().getClass().toString().replaceAll("class weka.classifiers.", "")) : new String(this.m_Node.getObject().getClass().toString());
        this.m_Label = new JLabel(string);
        if (font != null) {
            this.m_Label.setFont(font);
        }
        this.m_Label.setForeground(this.textForeground);
        this.m_Label.setBackground(this.textBackground);
        this.m_MoreInfoButton = new JButton("More Info");
        this.m_MoreInfoButton.addActionListener(this);
        this.m_MoreInfoButton.setForeground(this.textForeground);
        this.m_MoreInfoButton.setBackground(this.textBackground);
        this.add(this.m_ChooseClassButton);
        this.add(this.m_Label);
        this.add(this.m_MoreInfoButton);
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_GenericObjectEditor != null) {
            this.m_GenericObjectEditor.addPropertyChangeListener(propertyChangeListener);
        }
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateEditor();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_ChooseClassButton) {
            this.m_popup = this.m_GenericObjectEditor.getChooseClassPopupMenu();
            this.m_popup.addPopupMenuListener(this);
            this.m_popup.show(this.m_ChooseClassButton, this.m_ChooseClassButton.getX(), this.m_ChooseClassButton.getY());
            this.m_popup.pack();
        } else if (actionEvent.getSource() == this.m_MoreInfoButton) {
            this.openHelpFrame();
        }
    }

    protected void openHelpFrame() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setText(this.m_Node.getHelpText().toString());
        jTextArea.setCaretPosition(0);
        final JFrame jFrame = new JFrame("Information");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
                if (GenericObjectNodeEditor.this.m_HelpFrame == jFrame) {
                    GenericObjectNodeEditor.this.m_MoreInfoButton.setEnabled(true);
                }
            }
        });
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
        jFrame.pack();
        jFrame.setSize(400, 350);
        jFrame.setLocation(this.getTopLevelAncestor().getLocationOnScreen().x + this.getTopLevelAncestor().getSize().width, this.getTopLevelAncestor().getLocationOnScreen().y);
        jFrame.setVisible(true);
        this.m_HelpFrame = jFrame;
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.m_propertyChangeSupport.firePropertyChange(null, null, null);
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }
}

