/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class ItemSet
implements Serializable {
    private static final long serialVersionUID = 2724000045282835791L;
    protected int[] m_items;
    protected int m_counter;
    protected int m_totalTransactions;

    public ItemSet(int n) {
        this.m_totalTransactions = n;
    }

    public ItemSet(int n, int[] nArray) {
        this.m_totalTransactions = n;
        this.m_items = nArray;
        this.m_counter = 1;
    }

    public ItemSet(int[] nArray) {
        this.m_items = nArray;
        this.m_counter = 0;
    }

    public boolean containedBy(Instance instance) {
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (this.m_items[i] <= -1) continue;
            if (instance.isMissing(i)) {
                return false;
            }
            if (this.m_items[i] == (int)instance.value(i)) continue;
            return false;
        }
        return true;
    }

    public static FastVector deleteItemSets(FastVector fastVector, int n, int n2) {
        FastVector fastVector2 = new FastVector(fastVector.size());
        for (int i = 0; i < fastVector.size(); ++i) {
            ItemSet itemSet = (ItemSet)fastVector.elementAt(i);
            if (itemSet.m_counter < n || itemSet.m_counter > n2) continue;
            fastVector2.addElement(itemSet);
        }
        return fastVector2;
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        if (this.m_items.length != ((ItemSet)object).m_items.length) {
            return false;
        }
        for (int i = 0; i < this.m_items.length; ++i) {
            if (this.m_items[i] == ((ItemSet)object).m_items[i]) continue;
            return false;
        }
        return true;
    }

    public static Hashtable getHashtable(FastVector fastVector, int n) {
        Hashtable<ItemSet, Integer> hashtable = new Hashtable<ItemSet, Integer>(n);
        for (int i = 0; i < fastVector.size(); ++i) {
            ItemSet itemSet = (ItemSet)fastVector.elementAt(i);
            hashtable.put(itemSet, new Integer(itemSet.m_counter));
        }
        return hashtable;
    }

    public int hashCode() {
        long l = 0L;
        for (int i = this.m_items.length - 1; i >= 0; --i) {
            l += (long)(i * this.m_items[i]);
        }
        return (int)l;
    }

    public static FastVector mergeAllItemSets(FastVector fastVector, int n, int n2) {
        FastVector fastVector2 = new FastVector();
        block0: for (int i = 0; i < fastVector.size(); ++i) {
            ItemSet itemSet = (ItemSet)fastVector.elementAt(i);
            for (int j = i + 1; j < fastVector.size(); ++j) {
                ItemSet itemSet2 = (ItemSet)fastVector.elementAt(j);
                ItemSet itemSet3 = new ItemSet(n2);
                itemSet3.m_items = new int[itemSet.m_items.length];
                int n3 = 0;
                int n4 = 0;
                while (n3 < n) {
                    if (itemSet.m_items[n4] != itemSet2.m_items[n4]) continue block0;
                    if (itemSet.m_items[n4] != -1) {
                        ++n3;
                    }
                    itemSet3.m_items[n4] = itemSet.m_items[n4];
                    ++n4;
                }
                while (n4 < itemSet.m_items.length && (itemSet.m_items[n4] == -1 || itemSet2.m_items[n4] == -1)) {
                    itemSet3.m_items[n4] = itemSet.m_items[n4] != -1 ? itemSet.m_items[n4] : itemSet2.m_items[n4];
                    ++n4;
                }
                if (n4 != itemSet.m_items.length) continue;
                itemSet3.m_counter = 0;
                fastVector2.addElement(itemSet3);
            }
        }
        return fastVector2;
    }

    public static FastVector pruneItemSets(FastVector fastVector, Hashtable hashtable) {
        FastVector fastVector2 = new FastVector(fastVector.size());
        for (int i = 0; i < fastVector.size(); ++i) {
            int n;
            ItemSet itemSet = (ItemSet)fastVector.elementAt(i);
            for (n = 0; n < itemSet.m_items.length; ++n) {
                if (itemSet.m_items[n] == -1) continue;
                int n2 = itemSet.m_items[n];
                itemSet.m_items[n] = -1;
                if (hashtable.get(itemSet) == null) {
                    itemSet.m_items[n] = n2;
                    break;
                }
                itemSet.m_items[n] = n2;
            }
            if (n != itemSet.m_items.length) continue;
            fastVector2.addElement(itemSet);
        }
        return fastVector2;
    }

    public static void pruneRules(FastVector[] fastVectorArray, double d) {
        FastVector fastVector = new FastVector(fastVectorArray[0].size());
        FastVector fastVector2 = new FastVector(fastVectorArray[1].size());
        FastVector fastVector3 = new FastVector(fastVectorArray[2].size());
        for (int i = 0; i < fastVectorArray[0].size(); ++i) {
            if ((Double)fastVectorArray[2].elementAt(i) < d) continue;
            fastVector.addElement(fastVectorArray[0].elementAt(i));
            fastVector2.addElement(fastVectorArray[1].elementAt(i));
            fastVector3.addElement(fastVectorArray[2].elementAt(i));
        }
        fastVectorArray[0] = fastVector;
        fastVectorArray[1] = fastVector2;
        fastVectorArray[2] = fastVector3;
    }

    public static FastVector singletons(Instances instances) throws Exception {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (instances.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            int n = 0;
            while (n < instances.attribute(i).numValues()) {
                ItemSet itemSet = new ItemSet(instances.numInstances());
                itemSet.m_items = new int[instances.numAttributes()];
                for (int j = 0; j < instances.numAttributes(); ++j) {
                    itemSet.m_items[j] = -1;
                }
                itemSet.m_items[i] = n++;
                fastVector.addElement(itemSet);
            }
        }
        return fastVector;
    }

    public int support() {
        return this.m_counter;
    }

    public String toString(Instances instances) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (this.m_items[i] == -1) continue;
            stringBuffer.append(instances.attribute(i).name() + '=');
            stringBuffer.append(instances.attribute(i).value(this.m_items[i]) + ' ');
        }
        stringBuffer.append(this.m_counter);
        return stringBuffer.toString();
    }

    public void upDateCounter(Instance instance) {
        if (this.containedBy(instance)) {
            ++this.m_counter;
        }
    }

    public static void upDateCounters(FastVector fastVector, Instances instances) {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                ((ItemSet)enumeration.nextElement()).upDateCounter(instances.instance(i));
            }
        }
    }

    public int counter() {
        return this.m_counter;
    }

    public int[] items() {
        return this.m_items;
    }

    public int itemAt(int n) {
        return this.m_items[n];
    }

    public void setCounter(int n) {
        this.m_counter = n;
    }

    public void setItem(int[] nArray) {
        this.m_items = nArray;
    }

    public void setItemAt(int n, int n2) {
        this.m_items[n2] = n;
    }
}

