/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.ResultBindingIterator;
import com.hp.hpl.jena.rdql.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ResultBindingImpl
implements ResultBinding {
    ResultBindingImpl parent = null;
    List varNames = new ArrayList();
    List values = new ArrayList();
    List causalTriples = null;
    Query query = null;

    public ResultBindingImpl(ResultBindingImpl parent) {
        this.parent = parent;
    }

    public ResultBindingImpl() {
        this(null);
    }

    public int add(String varName, Value value) {
        this.varNames.add(varName);
        this.values.add(value);
        this.check();
        return this.varNames.size() - 1;
    }

    public int add(String varName, RDFNode node) {
        this.varNames.add(varName);
        this.values.add(node);
        this.check();
        return this.varNames.size() - 1;
    }

    public void setQuery(Query q) {
        this.query = q;
    }

    public void addTriple(Statement s) {
        if (this.causalTriples == null) {
            this.causalTriples = new ArrayList();
        }
        this.causalTriples.add(s);
    }

    public Set getTriples() {
        HashSet set = new HashSet();
        this.getTriples(set);
        return set;
    }

    private void getTriples(Collection acc) {
        if (this.causalTriples == null) {
            this.causalTriples = new ArrayList();
            if (this.query != null) {
                Model model = this.query.getSource();
                try {
                    Iterator iter = this.query.getTriplePatterns().iterator();
                    while (iter.hasNext()) {
                        Triple t1 = (Triple)iter.next();
                        Triple t2 = QueryEngine.substituteIntoTriple(t1, this);
                        RDFNode s = QueryEngine.convertGraphNodeToRDFNode(t2.getSubject(), model);
                        RDFNode p = QueryEngine.convertGraphNodeToRDFNode(t2.getPredicate(), model);
                        if (p instanceof Resource) {
                            p = model.createProperty(((Resource)p).getURI());
                        }
                        RDFNode o = QueryEngine.convertGraphNodeToRDFNode(t2.getObject(), model);
                        Statement stmt = model.createStatement((Resource)s, (Property)p, o);
                        this.causalTriples.add(stmt);
                    }
                }
                catch (Exception ex) {
                    System.err.println("ResultBindingImpl.getTriples: Substitution error: " + ex);
                }
            }
        }
        if (this.causalTriples == null) {
            return;
        }
        acc.addAll(this.causalTriples);
    }

    public Model mergeTriples(Model model) {
        Set s = this.getTriples();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            model.add((Statement)iter.next());
        }
        return model;
    }

    public Iterator names() {
        return new ResultBindingIterator(this);
    }

    public ResultBindingIterator iterator() {
        return new ResultBindingIterator(this);
    }

    public Object get(String varName) {
        return this.lookup(varName, 0);
    }

    private Object lookup(String varName, int localOffset) {
        for (int i = localOffset; i < this.varNames.size(); ++i) {
            if (!varName.equals((String)this.varNames.get(i))) continue;
            Object obj = this.values.get(i);
            if (obj instanceof RDFNode) {
                return obj;
            }
            if (!(obj instanceof Node)) continue;
            return QueryEngine.convertGraphNodeToRDFNode((Node)obj, this.query.getSource());
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookup(varName, 0);
    }

    void setParent(ResultBindingImpl p) {
        this.parent = p;
    }

    public int size() {
        int size = this.varNames.size();
        if (this.parent != null) {
            size += this.parent.size();
        }
        return size;
    }

    public void check() {
        for (int i = 0; i < this.varNames.size(); ++i) {
            String varName = (String)this.varNames.get(i);
            Object object = this.lookup(varName, i + 1);
        }
    }

    public String toString() {
        String tmp;
        StringBuffer sbuff = new StringBuffer("");
        for (int i = 0; i < this.varNames.size(); ++i) {
            if (i != 0) {
                sbuff.append(" ");
            }
            sbuff.append("(" + this.varNames.get(i) + ", " + this.values.get(i) + ")");
        }
        if (this.parent != null && (tmp = this.parent.toString()) != null && tmp.length() != 0) {
            sbuff.append(" ");
            sbuff.append(tmp);
        }
        return sbuff.toString();
    }
}

