/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Iterator;

public class PropertyBRWRule
extends BRWRule {
    public PropertyBRWRule() {
        super(new TriplePattern(Node.createVariable("p"), RDF.type.asNode(), RDF.Property.asNode()), new TriplePattern(null, Node.createVariable("s"), null));
    }

    public ExtendedIterator execute(TriplePattern query2, InfGraph infGraph, Finder data, HashSet firedRules) {
        RDFSInfGraph bRr = (RDFSInfGraph)infGraph;
        Node prop = query2.getSubject();
        if (bRr.getScanProperties()) {
            return NullIterator.instance;
        }
        TriplePattern pattern = PropertyBRWRule.instantiate(this.body, query2);
        return new BRWRule.RewriteIterator((Iterator)bRr.findRawWithContinuation(this.body, data), this);
    }

    static class PropertyNodeIterator
    extends UniqueExtendedIterator {
        public PropertyNodeIterator(Iterator underlying) {
            super(underlying);
        }

        protected Object nextIfNew() {
            Node prop = (Node)super.next();
            if (this.seen.add(prop)) {
                return new Triple(prop, RDF.type.asNode(), RDF.Property.asNode());
            }
            return null;
        }
    }
}

