% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StSignificanceTesting.R
\name{StSignificanceTesting}
\alias{StSignificanceTesting}
\title{Perform significance testing, DBMH or ORH}
\usage{
StSignificanceTesting (dataset, FOM = "wJAFROC", alpha = 0.05, 
   method = "DBMH", covEstMethod = "Jackknife", nBoots = 200, option = "ALL", 
   VarCompFlag = FALSE, FPFValue = 0.2)
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \link{RJafroc-package}}

\item{FOM}{The figure of merit, default \code{"wJAFROC"}, 
see \link{UtilFigureOfMerit}}

\item{alpha}{The significance level of the test of the null hypothesis that all 
treatment effects are zero; the default alpha is 0.05}

\item{method}{The significance testing method to be used. There are two options: 
\code{"DBMH"} (the default) or \code{"ORH"}, representing the Dorfman-Berbaum-Metz
and the Obuchowski-Rockette significance testing methods, respectively.}

\item{covEstMethod}{The method used to estimate the covariance matrix 
in ORH analysis; it can be \code{"Jackknife"}, \code{"Bootstrap"} 
or \code{"DeLong"}, the last assumes \code{FOM = "Wilcoxon"}, otherwise 
an error results. This parameter is not relevant if the analysis method 
is \code{"DBMH"}}

\item{nBoots}{The number of bootstraps (default is 200), relevant only if 
the \code{"Bootstrap"} method is used to estimate the covariance matrix
in the ORH method}

\item{option}{Determines which factors are regarded as random vs. fixed: 
\code{"RRRC"} = random-reader random case, 
\code{"FRRC"} = fixed-reader random case, 
\code{"RRFC"} = random-reader fixed case, 
\code{"ALL"} outputs the results of \code{"RRRC"}, \code{"FRRC"} 
and \code{"RRFC"} analyses}

\item{VarCompFlag}{If TRUE, only the appropriate (DBM or OR) variance components 
(six in all) are returned, default is FALSE}

\item{FPFValue}{Only needed for LROC data; where to evaluate a partial curve based
figure of merit. The default is 0.2.}
}
\value{
For \code{method = "DBMH"}  the returned value is a list with 22 members:

\item{fomArray}{The figure of merit array for each treatment-reader 
   combination}

\item{anovaY}{The ANOVA table of the pseudovalues over all treatments}

\item{anovaYi}{The ANOVA table of the pseudovalues for each treatment}

\item{varComp}{The variance components of the pseudovalue model underlying 
   the analysis, 6 values, in the following order: c("Var(R)", "Var(C)", 
   "Var(T*R)", "Var(T*C)", "Var(R*C)", "Var(Error)")}

\item{fRRRC}{For \strong{random-reader random-case} (RRRC) analysis, the 
   F-statistic for rejecting the null hypothesis of no treatment effect}

\item{ddfRRRC}{For RRRC analysis, the denominator degrees of freedom 
   of the F statistic}

\item{pRRRC}{For RRRC analysis, the p-value of the significance 
   test of the NH}

\item{ciDiffTrtRRRC}{For RRRC analysis, the confidence intervals and related 
   test statistics for the FOM differences between pairs of treatments}

\item{ciAvgRdrEachTrtRRRC}{For RRRC analysis, the confidence intervals 
   and related test statistics for rdr. avg. FOM in each treatment}

\item{fFRRC}{For \strong{fixed-reader random-case} (FRRC) analysis, the 
   F-statistic for rejecting the NH}

\item{ddfFRRC}{For FRRC analysis, the denominator degrees of freedom 
   of the F-statistic}

\item{pFRRC}{For FRRC analysis, the p-value of the significance 
   test of the NH}

\item{ciDiffTrtFRRC}{For FRRC analysis, the confidence intervals and related 
   test statistics for the FOM differences between pairs of treatments}

\item{ciAvgRdrEachTrtFRRC}{For FRRC analysis, the confidence intervals and 
   related tests for rdr. avg. FOM in each treatment}

\item{ssAnovaEachRdr}{The sum of squares table of the ANOVA of the 
   pseudovalues for each reader (based on data for the specified reader)}

\item{msAnovaEachRdr}{The mean squares table of the ANOVA of the 
   pseudovalues for each reader (based on data for the specified reader)}

\item{ciDiffTrtEachRdr}{The confidence intervals and related tests of the 
   FOM differences between pairs of treatments for each reader}

\item{fRRFC}{For \strong{random-reader fixed-case} (RRFC) analysis, 
   the F statistic}

\item{ddfRRFC}{For RRFC analysis, the denominator degrees of freedom 
   of the F statistic}

\item{pRRFC}{For RRFC analysis, the p-value for rejecting the NH}

\item{ciDiffTrtRRFC}{For RRFC analysis, the confidence intervals and 
   related test statistics for the FOM differences between pairs of treatments}

\item{ciAvgRdrEachTrtRRFC}{For RRFC analysis, the confidence intervals 
   and related tests for reader averaged FOM in each treatment}

For method = "ORH" the return value is a list with with 21 members:

\item{fomArray}{Figures of merit array. See the return of 
   \link{UtilFigureOfMerit}}

\item{msT}{Mean square of the figure of merit corresponding to 
   the treatment effect}

\item{msTR}{Mean square of the figure of merit corresponding to 
   the treatment-reader effect}

\item{varComp}{The variance components of the pseudovalue model underlying 
   the analysis, 6 values, in
the following order: c("Var(R)", "Var(T*R)", "COV1", "COV2", "COV3", "Var(Error)")}

\item{fRRRC}{Same as \code{DBMH} method}

\item{ddfRRRC}{Same as \code{DBMH} method}

\item{pRRRC}{Same as \code{DBMH} method}

\item{ciDiffTrtRRRC}{Same as \code{DBMH} method}

\item{ciAvgRdrEachTrtRRRC}{Same as \code{DBMH} method}

\item{fFRRC}{Same as \code{DBMH} method}

\item{ddfFRRC}{Same as \code{DBMH} method}

\item{pFRRC}{Same as \code{DBMH} method}

\item{ciDiffTrtFRRC}{Same as \code{DBMH} method}

\item{ciAvgRdrEachTrtFRRC}{Same as \code{DBMH} method}

\item{ciDiffTrtEachRdr}{Same as \code{DBMH} method}

\item{varCovEachRdr}{Obuchowski-Rockette Variance and Cov1 
   estimates for each reader}

\item{fRRFC}{Same as \code{DBMH} method}

\item{ddfRRFC}{Same as \code{DBMH} method}

\item{pRRFC}{Same as \code{DBMH} method}

\item{ciDiffTrtRRFC}{Same as \code{DBMH} method}

\item{ciAvgRdrEachTrtRRFC}{Same as \code{DBMH} method}
}
\description{
Performs Dorfman-Berbaum-Metz (DBM) or Obuchowski-Rockette (OR) 
   significance testing with Hillis' improvements, for specified dataset; 
   significance testing refers to analysis designed to assign a P-value for 
   rejecting a null hypothesis (NH); the most common NH is that the reader-averaged 
   figure of merit (FOM) difference between treatments is zero. The results of 
   the analysis are better visualized in the text or, preferably, 
   Excel-formatted, files produced by \link{UtilOutputReport}.
}
\examples{
retDbmRoc  <- StSignificanceTesting(dataset02, 
FOM = "Wilcoxon", method = "DBMH") 

\dontrun{
retDbmwJAFROC  <- StSignificanceTesting(dataset05) # default is weighted JAFROC

retDbmHrAuc  <- StSignificanceTesting(dataset05, 
FOM = "HrAuc", method = "DBMH") 
print(retDbmHrAuc) 

retDbmSongA1  <- StSignificanceTesting(dataset05, 
FOM = "SongA1", method = "DBMH") 
print(retDbmSongA1)

retDbmSongA2  <- StSignificanceTesting(dataset05, 
FOM = "SongA2", method = "DBMH") 
print(retDbmSongA2)

retDbmwJafroc1  <- StSignificanceTesting(dataset05, 
FOM = "wJAFROC1", method = "DBMH")
print(retDbmwJafroc1)
 
retDbmJafroc1  <- StSignificanceTesting(dataset05, 
FOM = "JAFROC1", method = "DBMH")
print(retDbmJafroc1)
 
retDbmJAFROC  <- StSignificanceTesting(dataset05, 
FOM = "JAFROC", method = "DBMH") 
print(retDbmJAFROC)
 
}

retOR <- StSignificanceTesting(dataset02, 
FOM = "Wilcoxon", method = "ORH")
print(retOR)


}
\references{
Dorfman DD, Berbaum KS, Metz CE (1992) ROC characteristic rating analysis: 
Generalization to the Population of Readers and Patients with the Jackknife method, Invest. Radiol. 27, 723-731.

Obuchowski NA, Rockette HE (1995) Hypothesis Testing of the Diagnostic Accuracy for Multiple Diagnostic Tests:  
An ANOVA Approach with Dependent Observations, Communications in Statistics: Simulation and Computation 24, 285-308.

Hillis SL (2014) A marginal-mean ANOVA approach for analyzing multireader multicase radiological imaging data, 
Statistics in medicine 33, 330-360.

Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 
\url{https://www.crcpress.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}
}
