/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DSDIdentifier;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxExceptionFactory;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v20.CodelistParser;
import it.bancaditalia.oss.sdmx.parser.v20.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v20.DataflowParser;
import it.bancaditalia.oss.sdmx.parser.v20.GenericDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.RestQueryBuilder;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public abstract class RestSdmx20Client
extends RestSdmxClient {
    private String acceptHdr = null;
    protected String format = "compact_v2";

    public RestSdmx20Client(String string, URL uRL, boolean bl, String string2, String string3) {
        super(string, uRL, bl, false, false);
        this.acceptHdr = string2;
        this.format = string3;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap;
        block11: {
            String string = null;
            Reader reader = null;
            hashMap = new HashMap<String, Dataflow>();
            string = this.buildFlowQuery("ALL", null, null);
            reader = this.runQuery(string, null);
            try {
                List<Dataflow> list = DataflowParser.parse(reader);
                if (list.size() > 0) {
                    hashMap = new HashMap();
                    for (Dataflow dataflow : list) {
                        hashMap.put(dataflow.getId(), dataflow);
                    }
                    break block11;
                }
                throw new SdmxXmlContentException("The query returned zero dataflows");
            }
            catch (XMLStreamException xMLStreamException) {
                throw SdmxExceptionFactory.wrap(xMLStreamException);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    logger.severe("Exception caught closing stream.");
                }
            }
        }
        return hashMap;
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        Dataflow dataflow;
        block11: {
            String string4 = null;
            Reader reader = null;
            dataflow = null;
            string4 = this.buildFlowQuery(string, string2, string3);
            reader = this.runQuery(string4, null);
            try {
                List<Dataflow> list = DataflowParser.parse(reader);
                if (list.size() >= 1) {
                    for (Dataflow dataflow2 : list) {
                        if (!dataflow2.getId().equalsIgnoreCase(string)) continue;
                        dataflow = dataflow2;
                    }
                    break block11;
                }
                throw new SdmxXmlContentException("The query returned zero dataflows");
            }
            catch (XMLStreamException xMLStreamException) {
                throw SdmxExceptionFactory.wrap(xMLStreamException);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    logger.severe("Exception caught closing stream.");
                }
            }
        }
        return dataflow;
    }

    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier, boolean bl) throws SdmxException {
        String string = null;
        Reader reader = null;
        DataFlowStructure dataFlowStructure = new DataFlowStructure();
        if (dSDIdentifier != null) {
            string = this.buildDSDQuery(dSDIdentifier.getId(), dSDIdentifier.getAgency(), dSDIdentifier.getVersion(), bl);
            reader = this.runQuery(string, null);
            try {
                dataFlowStructure = DataStructureParser.parse(reader).get(0);
            }
            catch (XMLStreamException xMLStreamException) {
                throw SdmxExceptionFactory.wrap(xMLStreamException);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    logger.severe("Exception caught closing stream.");
                }
            }
        }
        throw new InvalidParameterException("Null dsd in input");
        return dataFlowStructure;
    }

    @Override
    public Map<String, String> getCodes(String string, String string2, String string3) throws SdmxException {
        String string4 = null;
        Reader reader = null;
        Map<String, String> map = null;
        string4 = this.buildCodelistQuery(string, string2, string3);
        reader = this.runQuery(string4, null);
        try {
            map = CodelistParser.parse(reader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw SdmxExceptionFactory.wrap(xMLStreamException);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                logger.severe("Exception caught closing stream.");
            }
        }
        return map;
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        DataParsingResult dataParsingResult = this.getData(dataflow, dataFlowStructure, string, string2, string3, bl, string4, bl2);
        return dataParsingResult.getData();
    }

    @Override
    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        String string5 = null;
        Reader reader = null;
        DataParsingResult dataParsingResult = new DataParsingResult();
        string5 = this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2);
        try {
            reader = this.runQuery(string5, this.acceptHdr);
            dataParsingResult = this.format != null ? CompactDataParser.parse(reader, dataFlowStructure, dataflow.getId(), !bl) : GenericDataParser.parse(reader, dataFlowStructure, dataflow.getId(), !bl);
        }
        catch (XMLStreamException xMLStreamException) {
            throw SdmxExceptionFactory.wrap(xMLStreamException);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    logger.severe("Exception caught closing stream.");
                }
            }
        }
        return dataParsingResult;
    }

    @Override
    protected String buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.endpoint != null && dataflow != null && string != null && !string.isEmpty()) {
            String string5 = RestQueryBuilder.getDataQuery(this.endpoint, dataflow.getFullIdentifier(), string, string2, string3, bl, string4, bl2, this.format);
            return string5;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.endpoint);
    }
}

