/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.client.HttpsSdmxClient;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import it.bancaditalia.oss.sdmx.util.SdmxProxySelector;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SDMXClientFactory {
    private static final String ECB_PROVIDER = "http://sdw-wsrest.ecb.europa.eu/service";
    private static final String EUROSTAT_PROVIDER = "http://ec.europa.eu/eurostat/SDMX/diss-web/rest";
    private static final String ISTAT_PROVIDER = "http://sdmx.istat.it/SDMXWS/rest";
    private static final String sourceClass;
    protected static Logger logger;
    private static Map<String, Provider> providers;

    private static void initBuiltInProviders() {
        try {
            SDMXClientFactory.addProvider("ECB", new URL(ECB_PROVIDER), false, false, true, "European Central Bank");
            SDMXClientFactory.addProvider("EUROSTAT", new URL(EUROSTAT_PROVIDER), false, false, true, "Eurostat");
            SDMXClientFactory.addProvider("ISTAT", new URL(ISTAT_PROVIDER), false, false, false, "Istituto nazionale di statistica");
        }
        catch (MalformedURLException malformedURLException) {
            logger.severe("Exception. Class: " + malformedURLException.getClass().getName() + " .Message: " + malformedURLException.getMessage());
            logger.log(Level.FINER, "", malformedURLException);
        }
        SDMXClientFactory.addProvider("OECD", null, false, false, false, "The Organisation for Economic Co-operation and Development");
        SDMXClientFactory.addProvider("OECD_RESTR", null, true, false, false, "The Organisation for Economic Co-operation and Development, RESTRICTED ACCESS");
        SDMXClientFactory.addProvider("ILO", null, false, false, false, "International Labour Organization");
        SDMXClientFactory.addProvider("IMF", null, false, false, false, "International Monetary Fund");
        SDMXClientFactory.addProvider("INEGI", null, false, false, false, "Instituto Nacional de Estadistica y Geografia");
        SDMXClientFactory.addProvider("ABS", null, false, false, false, "Australian Bureau of Statistics");
        SDMXClientFactory.addProvider("WB", null, false, false, false, "World Bank (BETA provider)");
        SDMXClientFactory.addProvider("NBB", null, false, false, false, "National Bank Belgium");
        SDMXClientFactory.addProvider("UIS", null, false, false, false, "Unesco Institute for Statistics");
        ServiceLoader<GenericSDMXClient> serviceLoader = ServiceLoader.load(GenericSDMXClient.class);
        for (GenericSDMXClient genericSDMXClient : serviceLoader) {
            SDMXClientFactory.addProvider(genericSDMXClient.getClass().getSimpleName(), null, genericSDMXClient.needsCredentials(), false, false, genericSDMXClient.getClass().getSimpleName());
        }
    }

    public static void addProvider(String string, URL uRL, boolean bl, boolean bl2, boolean bl3, String string2) {
        Provider provider = new Provider(string, uRL, bl, bl2, bl3, string2);
        providers.put(string, provider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GenericSDMXClient createClient(String string) throws SdmxException {
        Object object;
        logger.entering(sourceClass, "createClient");
        logger.fine("Create an SDMX client for '" + string + "'");
        GenericSDMXClient genericSDMXClient = null;
        Provider provider = providers.get(string);
        String string2 = null;
        String string3 = "The provider '" + string + "' is not available in this configuration.";
        if (provider != null && provider.getEndpoint() != null) {
            string2 = provider.getEndpoint().getHost();
            if (provider.getEndpoint().getProtocol().equals("http")) {
                genericSDMXClient = new RestSdmxClient(provider.getName(), provider.getEndpoint(), provider.isNeedsCredentials(), provider.isNeedsURLEncoding(), provider.isSupportsCompression());
            } else {
                if (!provider.getEndpoint().getProtocol().equals("https")) {
                    logger.severe("The protocol '" + provider.getEndpoint().getProtocol() + "' is not supported.");
                    throw new SdmxException(string3);
                }
                try {
                    genericSDMXClient = new HttpsSdmxClient(provider.getName(), provider.getEndpoint(), provider.isNeedsCredentials(), provider.isNeedsURLEncoding(), provider.isSupportsCompression());
                }
                catch (KeyManagementException keyManagementException) {
                    logger.severe("Exception. Class: " + keyManagementException.getClass().getName() + " .Message: " + keyManagementException.getMessage());
                    logger.log(Level.FINER, "", keyManagementException);
                    throw new SdmxException(string3);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    logger.severe("Exception. Class: " + noSuchAlgorithmException.getClass().getName() + " .Message: " + noSuchAlgorithmException.getMessage());
                    logger.log(Level.FINER, "", noSuchAlgorithmException);
                    throw new SdmxException(string3);
                }
            }
        } else {
            try {
                object = Class.forName("it.bancaditalia.oss.sdmx.client.custom." + string);
                genericSDMXClient = (GenericSDMXClient)((Class)object).newInstance();
                string2 = genericSDMXClient.getEndpoint().getHost();
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.severe("The provider '" + string + "' is not available in this configuration.");
                throw new SdmxException(string3);
            }
            catch (Exception exception) {
                logger.severe("Exception caught. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                logger.log(Level.FINER, "Exception caught. ", exception);
                throw new SdmxException(string3);
            }
        }
        object = ProxySelector.getDefault();
        if (object != null && object instanceof SdmxProxySelector) {
            ((SdmxProxySelector)object).addToDefaultProxy(string2);
        }
        logger.exiting(sourceClass, "createClient");
        return genericSDMXClient;
    }

    public static Map<String, Provider> getProviders() {
        return providers;
    }

    static {
        providers = new HashMap<String, Provider>();
        Configuration.init();
        SDMXClientFactory.initBuiltInProviders();
        sourceClass = SDMXClientFactory.class.getSimpleName();
        logger = Configuration.getSdmxLogger();
    }
}

