/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.helper;

import it.bankitalia.reri.sia.util.Configuration;
import it.bankitalia.reri.sia.util.SdmxException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;

public class SdmxNode {
    protected static Logger logger = Configuration.getSdmxLogger();
    protected String id;
    protected String description;
    private boolean orderLexicographically;

    public SdmxNode(String string, String string2, boolean bl) {
        this.id = string;
        this.description = string2;
        this.orderLexicographically = bl;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getId() + " : " + this.getDescription();
    }

    public void expand(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.removeAllChildren();
        List<SdmxNode> list = null;
        try {
            list = this.listSubNodes();
        }
        catch (SdmxException sdmxException) {
            logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
            logger.log(Level.FINER, "", sdmxException);
        }
        if (list != null) {
            Vector<SdmxNode> vector = this.orderNodes(list);
            for (int i = 0; i < vector.size(); ++i) {
                SdmxNode sdmxNode = vector.elementAt(i);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(sdmxNode);
                if (sdmxNode.hasSubNodes()) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new SdmxNode("Calling provider, please wait...", "", false)));
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    public boolean hasSubNodes() {
        return true;
    }

    private int compareTo(SdmxNode sdmxNode) {
        return this.id.compareToIgnoreCase(sdmxNode.getId());
    }

    private Vector<SdmxNode> orderNodes(List<SdmxNode> list) {
        Vector<SdmxNode> vector = new Vector<SdmxNode>();
        if (!this.orderLexicographically) {
            vector.addAll(list);
        } else {
            for (SdmxNode sdmxNode : list) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    SdmxNode sdmxNode2 = vector.elementAt(i);
                    if (sdmxNode.compareTo(sdmxNode2) >= 0) continue;
                    vector.insertElementAt(sdmxNode, i);
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector.addElement(sdmxNode);
            }
        }
        return vector;
    }

    public List<SdmxNode> listSubNodes() throws SdmxException {
        return null;
    }
}

