/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.ConcentratedLikelihoodEstimation;
import ec.tstoolkit.arima.estimation.ModifiedLjungBoxFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.modelling.IRobustStandardDeviationComputer;
import ec.tstoolkit.modelling.arima.AbstractSingleOutlierDetector;
import ec.tstoolkit.modelling.arima.TrenchSolver;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.LevelShiftFactory;
import ec.tstoolkit.timeseries.regression.SeasonalOutlierFactory;
import ec.tstoolkit.timeseries.regression.TransitoryChangeFactory;

public class TrenchSingleOutlierDetector<T extends IArimaModel>
extends AbstractSingleOutlierDetector<T> {
    private TrenchSolver m_solver;
    private double m_threshold = 1.0E-6;

    public TrenchSingleOutlierDetector() {
        super(IRobustStandardDeviationComputer.mad());
    }

    public TrenchSingleOutlierDetector(IRobustStandardDeviationComputer computer) {
        super(computer);
    }

    @Override
    protected boolean calc() {
        this.m_solver = new TrenchSolver(this.getModel());
        this.calcYL();
        this.processOutliers();
        return true;
    }

    private void calcYL() {
        ConcentratedLikelihoodEstimation estimator = new ConcentratedLikelihoodEstimation(new ModifiedLjungBoxFilter());
        estimator.estimate(this.getModel());
        this.getStandardDeviationComputer().compute(new DataBlock(estimator.getResiduals(), this.getModel().getArma().getARCount() + this.getModel().getArma().getMACount(), estimator.getResiduals().length, 1));
    }

    private void processdefOutlier(int io) {
        int n = this.getModel().getY().getLength();
        int d = this.getModel().getDifferencingFilter().getDegree();
        double[] xo = new double[n + d];
        IOutlierFactory fac = this.getOutlierFactory(io);
        IOutlierVariable o = fac.create(this.getDomain().get(d));
        o.data(this.getDomain().getStart(), new DataBlock(xo));
        double[] dao = new double[n];
        this.getModel().getDifferencingFilter().filter(new DataBlock(xo), new DataBlock(dao));
        int ni = 0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(dao[i]) > this.m_threshold)) continue;
            ++ni;
        }
        int[] idx = new int[ni];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(dao[i]) > this.m_threshold)) continue;
            idx[j++] = i;
        }
        for (int a = 0; a < n; ++a) {
            if (!this.isDefined(a, io)) continue;
            this.setT(a, io, this.m_solver.TStat(d, a, dao, idx) / this.getMAD());
        }
    }

    private void processOutliers() {
        int d = this.getModel().getDifferencingFilter().getDegree();
        TrenchSolver dsolver = null;
        for (int io = 0; io < this.getOutlierFactoriesCount(); ++io) {
            IOutlierFactory o = this.getOutlierFactory(io);
            if (o instanceof TransitoryChangeFactory) {
                TransitoryChangeFactory tc = (TransitoryChangeFactory)o;
                this.processtcOutlier(io, tc.getCoefficient());
                continue;
            }
            if (d > 0) {
                this.processdefOutlier(io);
                continue;
            }
            LevelShiftFactory ls = null;
            if (o instanceof LevelShiftFactory) {
                ls = (LevelShiftFactory)o;
            }
            SeasonalOutlierFactory s = null;
            if (o instanceof SeasonalOutlierFactory) {
                s = (SeasonalOutlierFactory)o;
            }
            if (ls != null || s != null) {
                if (dsolver == null) {
                    dsolver = this.m_solver.clone();
                    dsolver.difference();
                }
                this.processstOutlier(dsolver, io);
                continue;
            }
            this.processdefOutlier(io);
        }
    }

    private void processstOutlier(TrenchSolver solver, int io) {
        int n = this.getModel().getY().getLength();
        double[] xo = new double[n];
        IOutlierFactory fac = this.getOutlierFactory(io);
        IOutlierVariable o = fac.create(this.getDomain().getStart());
        o.data(this.getDomain().getStart(), new DataBlock(xo));
        double[] dao = new double[n];
        DataBlock DAO = new DataBlock(dao);
        this.getModel().getDifferencingFilter().filter(new DataBlock(xo), DAO);
        DAO.difference();
        int ni = 0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(dao[i]) > this.m_threshold)) continue;
            ++ni;
        }
        int[] idx = new int[ni];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(dao[i]) > this.m_threshold)) continue;
            idx[j++] = i;
        }
        for (int a = 0; a < n; ++a) {
            if (!this.isDefined(a, io)) continue;
            this.setT(a, io, solver.TStat(0, a, dao, idx) / this.getMAD());
        }
    }

    private void processtcOutlier(int io, double delta) {
        int n = this.getModel().getY().getLength();
        int d = this.getModel().getDifferencingFilter().getDegree();
        double[] xo = new double[n + d];
        IOutlierFactory fac = this.getOutlierFactory(io);
        TrenchSolver solver = this.m_solver.clone();
        solver.difference(delta);
        int[] idx = null;
        double[] dao = null;
        for (int a = 0; a < n; ++a) {
            if (a == d || this.isDefined(a, io) && a < d) {
                int i;
                IOutlierVariable o = fac.create(this.getDomain().get(a));
                o.data(this.getDomain().getStart(), new DataBlock(xo));
                dao = new double[n];
                DataBlock DAO = new DataBlock(dao);
                this.getModel().getDifferencingFilter().filter(new DataBlock(xo), DAO);
                DAO.difference(delta);
                int ni = 0;
                for (i = 0; i < n; ++i) {
                    if (!(Math.abs(dao[i]) > this.m_threshold)) continue;
                    ++ni;
                }
                idx = new int[ni];
                int j = 0;
                for (i = 0; i < n; ++i) {
                    if (!(Math.abs(dao[i]) > this.m_threshold)) continue;
                    idx[j++] = i;
                }
            }
            if (!this.isDefined(a, io)) continue;
            if (a <= d) {
                this.setT(a, io, solver.TStat(0, 0, dao, idx) / this.getMAD());
                continue;
            }
            this.setT(a, io, solver.TStat(d, a, dao, idx) / this.getMAD());
        }
    }
}

