/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.tdvar;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.jdr.mapping.DiffuseLikelihoodInfo;
import ec.tstoolkit.jdr.mapping.SarimaInfo;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.SarimaMapping;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfAlgorithm;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.RegSsf;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfAlgorithm;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.SsfFunction;
import ec.tstoolkit.ssf.SsfFunctionInstance;
import ec.tstoolkit.ssf.SsfModel;
import ec.tstoolkit.ssf.TimeVaryingRegSsf;
import ec.tstoolkit.ssf.arima.SsfArima;
import ec.tstoolkit.timeseries.DayClustering;
import ec.tstoolkit.timeseries.calendars.GenericTradingDays;
import ec.tstoolkit.timeseries.regression.GenericTradingDaysVariables;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.RegressionUtilities;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.LinkedHashMap;
import java.util.Map;
import jd2.algorithm.IProcResults;
import jd2.information.InformationMapping;

public final class TimeVaryingRegression {
    public static Results regarima(TsData s, String td, String svar, double diffAic) {
        DayClustering dc = TimeVaryingRegression.days(td);
        Matrix mtd = TimeVaryingRegression.generate(s.getDomain(), dc);
        Matrix nvar = TimeVaryingRegression.generateVar(dc, svar);
        SsfData data = new SsfData((IReadDataBlock)s, null);
        TDvarMapping mapping0 = new TDvarMapping(s.getFrequency().intValue(), mtd, null);
        ReadDataBlock p0 = new ReadDataBlock(new double[]{-0.6, -0.6});
        SsfModel model = new SsfModel(mapping0.map((IReadDataBlock)p0), (ISsfData)new SsfData((IReadDataBlock)s, null), null, null);
        SsfFunction fn0 = new SsfFunction(model, (IParametricMapping)mapping0, (ISsfAlgorithm)new SsfAlgorithm());
        SarimaSpecification spec = new SarimaSpecification(s.getFrequency().intValue());
        spec.airline();
        LevenbergMarquardtMethod min = new LevenbergMarquardtMethod();
        min.setConvergenceCriterion(1.0E-12);
        min.minimize((ISsqFunction)fn0, (IReadDataBlock)p0);
        SsfFunctionInstance rfn0 = (SsfFunctionInstance)min.getResult();
        DiffuseConcentratedLikelihood ll0 = rfn0.getLikelihood();
        IReadDataBlock ep0 = rfn0.getParameters();
        SarimaModel arima0 = new SarimaModel(spec);
        arima0.setTheta(1, ep0.get(0));
        arima0.setBTheta(1, ep0.get(1));
        TDvarMapping mapping = new TDvarMapping(s.getFrequency().intValue(), mtd, nvar);
        ReadDataBlock p = new ReadDataBlock(new double[]{ep0.get(0), ep0.get(1), 1.0E-4});
        model = new SsfModel(mapping.map((IReadDataBlock)p), (ISsfData)new SsfData((IReadDataBlock)s, null), null, null);
        SsfFunction fn = new SsfFunction(model, (IParametricMapping)mapping, (ISsfAlgorithm)new SsfAlgorithm());
        min.minimize((ISsqFunction)fn, (IReadDataBlock)p);
        SsfFunctionInstance rfn = (SsfFunctionInstance)min.getResult();
        DiffuseConcentratedLikelihood ll = rfn.getLikelihood();
        IReadDataBlock ep = rfn.getParameters();
        SarimaModel arima = new SarimaModel(spec);
        arima.setTheta(1, ep.get(0));
        arima.setBTheta(1, ep.get(1));
        double tdvar = ep.get(2);
        double aic0 = ll0.AIC(2);
        double aic = ll.AIC(3);
        ISsf ssf = aic + diffAic < aic0 ? rfn.ssf : rfn0.ssf;
        Smoother smoother = new Smoother();
        smoother.setSsf(ssf);
        smoother.setCalcVar(true);
        SmoothingResults fs = new SmoothingResults(true, true);
        smoother.process((ISsfData)data, fs);
        Matrix c = new Matrix(mtd.getRowsCount(), mtd.getColumnsCount() + 1);
        Matrix ec = new Matrix(mtd.getRowsCount(), mtd.getColumnsCount() + 1);
        int del = s.getFrequency().intValue() + 2;
        double nwe = dc.getGroupCount(0);
        double[] z = new double[c.getColumnsCount() - 1];
        for (int i = 0; i < z.length; ++i) {
            c.column(i).copyFrom(fs.component(del + i), 0);
            ec.column(i).copyFrom(fs.componentVar(del + i), 0);
            z[i] = (double)dc.getGroupCount(i + 1) / nwe;
            c.column(z.length).addAY(-z[i], c.column(i));
        }
        DataBlock Z = new DataBlock(z);
        double v = fs.getStandardError() * fs.getStandardError();
        for (int i = 0; i < c.getRowsCount(); ++i) {
            SubMatrix var = fs.P(i);
            int n = var.getRowsCount();
            var = var.extract(del, n, del, n);
            ec.set(i, z.length, SymmetricMatrix.quadraticForm((SubMatrix)var, (DataBlock)Z) * v);
        }
        double[] sec = ec.internalStorage();
        for (int i = 0; i < sec.length; ++i) {
            sec[i] = sec[i] <= 0.0 ? 0.0 : Math.sqrt(sec[i]);
        }
        return Results.builder().domain(s.getDomain()).arima0(arima0).ll0(ll0).arima(arima).ll(ll).variables(mtd).coefficients(c).coefficientsStde(ec).nvar(tdvar).build();
    }

    private static DayClustering days(String td) {
        DayClustering dc;
        switch (td) {
            case "TD2": {
                dc = DayClustering.TD2;
                break;
            }
            case "TD3": {
                dc = DayClustering.TD3;
                break;
            }
            case "TD3c": {
                dc = DayClustering.TD3c;
                break;
            }
            case "TD4": {
                dc = DayClustering.TD4;
                break;
            }
            default: {
                dc = DayClustering.TD7;
            }
        }
        return dc;
    }

    private static Matrix generate(TsDomain domain, DayClustering dc) {
        GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)dc);
        return RegressionUtilities.matrix((ITsVariable)new GenericTradingDaysVariables(gtd), (TsDomain)domain);
    }

    private static Matrix generateVar(DayClustering dc, String var) {
        int groupsCount = dc.getGroupsCount();
        Matrix full = Matrix.square((int)7);
        if (!var.equalsIgnoreCase("Contrasts")) {
            full.set(-0.14285714285714285);
        }
        full.diagonal().add(1.0);
        Matrix Q = new Matrix(groupsCount - 1, 7);
        int[] gdef = dc.getGroupsDefinition();
        for (int i = 1; i < groupsCount; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (gdef[j] != i) continue;
                Q.set(i - 1, j, 1.0);
            }
        }
        return SymmetricMatrix.quadraticFormT((Matrix)full, (Matrix)Q);
    }

    private TimeVaryingRegression() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class TDvarMapping
    implements IParametricMapping<ISsf> {
        private final int frequency;
        private final Matrix td;
        private final Matrix nvar;
        private static final SarimaMapping airlineMapping;

        TDvarMapping(int freq, Matrix td, Matrix nvar) {
            this.frequency = freq;
            this.td = td;
            this.nvar = nvar;
        }

        public ISsf map(IReadDataBlock p) {
            SarimaSpecification spec = new SarimaSpecification(this.frequency);
            spec.airline();
            SarimaModel arima = new SarimaModel(spec);
            arima.setTheta(1, p.get(0));
            arima.setBTheta(1, p.get(1));
            SsfArima ssf = new SsfArima((IArimaModel)arima);
            if (this.nvar != null) {
                double nv = p.get(2);
                Matrix v = this.nvar.clone();
                v.mul(nv);
                return new TimeVaryingRegSsf((ISsf)ssf, this.td.all(), v);
            }
            return new RegSsf((ISsf)ssf, this.td.all());
        }

        public IReadDataBlock map(ISsf t) {
            if (t instanceof TimeVaryingRegSsf) {
                TimeVaryingRegSsf ssf = (TimeVaryingRegSsf)t;
                SsfArima ssfarima = (SsfArima)ssf.getCoreSsf();
                SarimaModel arima = (SarimaModel)ssfarima.getModel();
                Matrix fnv = ssf.getFullNoiseVar();
                double[] p = new double[]{arima.theta(1), arima.btheta(1), fnv.diagonal().sum() / this.nvar.diagonal().sum()};
                return new ReadDataBlock(p);
            }
            RegSsf ssf = (RegSsf)t;
            SsfArima ssfarima = (SsfArima)ssf.getCoreSsf();
            SarimaModel arima = (SarimaModel)ssfarima.getModel();
            double[] p = new double[]{arima.theta(1), arima.btheta(1)};
            return new ReadDataBlock(p);
        }

        public boolean checkBoundaries(IReadDataBlock inparams) {
            if (this.nvar != null) {
                return inparams.get(2) >= 0.0 && inparams.get(2) < 10.0 && airlineMapping.checkBoundaries(inparams.rextract(0, 2));
            }
            return airlineMapping.checkBoundaries(inparams.rextract(0, 2));
        }

        public double epsilon(IReadDataBlock inparams, int idx) {
            if (idx < 2) {
                return airlineMapping.epsilon(inparams, idx);
            }
            return Math.max(inparams.get(2) * 0.001, 1.0E-9);
        }

        public int getDim() {
            return this.nvar == null ? 2 : 3;
        }

        public double lbound(int idx) {
            if (idx < 2) {
                return airlineMapping.lbound(idx);
            }
            return 0.0;
        }

        public double ubound(int idx) {
            if (idx < 2) {
                return airlineMapping.ubound(idx);
            }
            return 10.0;
        }

        public ParamValidation validate(IDataBlock ioparams) {
            ParamValidation pv = ParamValidation.Valid;
            if (this.nvar != null && ioparams.get(2) < 0.0) {
                pv = ParamValidation.Changed;
                ioparams.set(2, Math.min(10.0, -ioparams.get(2)));
            }
            if (this.nvar != null && ioparams.get(2) > 10.0) {
                pv = ParamValidation.Changed;
                ioparams.set(2, 10.0);
            }
            ParamValidation pv2 = airlineMapping.validate(ioparams.extract(0, 2));
            if (pv == ParamValidation.Valid && pv2 == ParamValidation.Valid) {
                return ParamValidation.Valid;
            }
            if (pv == ParamValidation.Invalid || pv2 == ParamValidation.Invalid) {
                return ParamValidation.Invalid;
            }
            return ParamValidation.Changed;
        }

        public String getDescription(int idx) {
            if (idx < 2) {
                return airlineMapping.getDescription(idx);
            }
            return "noise stdev";
        }

        static {
            SarimaSpecification spec = new SarimaSpecification(12);
            spec.airline();
            airlineMapping = new SarimaMapping(spec, true);
        }
    }

    public static final class Results
    implements IProcResults {
        private final TsDomain domain;
        private final Matrix variables;
        private final Matrix coefficients;
        private final Matrix coefficientsStde;
        private final SarimaModel arima;
        private final SarimaModel arima0;
        private final double nvar;
        private final DiffuseConcentratedLikelihood ll0;
        private final DiffuseConcentratedLikelihood ll;
        private static final String ARIMA = "arima";
        private static final String LL = "likelihood";
        private static final String STDCOEFF = "coefficients.stde";
        private static final String COEFF = "coefficients.value";
        private static final String TD = "td";
        private static final String TDEFFECT = "tdeffect";
        private static final InformationMapping<Results> MAPPING = new InformationMapping<Results>(Results.class);

        @Override
        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        @Override
        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        @Override
        public <T> T getData(String id, Class<T> tclass) {
            return MAPPING.getData(this, id, tclass);
        }

        public static final InformationMapping<Results> getMapping() {
            return MAPPING;
        }

        Results(TsDomain domain, Matrix variables, Matrix coefficients, Matrix coefficientsStde, SarimaModel arima, SarimaModel arima0, double nvar, DiffuseConcentratedLikelihood ll0, DiffuseConcentratedLikelihood ll) {
            this.domain = domain;
            this.variables = variables;
            this.coefficients = coefficients;
            this.coefficientsStde = coefficientsStde;
            this.arima = arima;
            this.arima0 = arima0;
            this.nvar = nvar;
            this.ll0 = ll0;
            this.ll = ll;
        }

        public static ResultsBuilder builder() {
            return new ResultsBuilder();
        }

        public TsDomain getDomain() {
            return this.domain;
        }

        public Matrix getVariables() {
            return this.variables;
        }

        public Matrix getCoefficients() {
            return this.coefficients;
        }

        public Matrix getCoefficientsStde() {
            return this.coefficientsStde;
        }

        public SarimaModel getArima() {
            return this.arima;
        }

        public SarimaModel getArima0() {
            return this.arima0;
        }

        public double getNvar() {
            return this.nvar;
        }

        public DiffuseConcentratedLikelihood getLl0() {
            return this.ll0;
        }

        public DiffuseConcentratedLikelihood getLl() {
            return this.ll;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            TsDomain this$domain = this.getDomain();
            TsDomain other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            Matrix this$variables = this.getVariables();
            Matrix other$variables = other.getVariables();
            if (this$variables == null ? other$variables != null : !this$variables.equals(other$variables)) {
                return false;
            }
            Matrix this$coefficients = this.getCoefficients();
            Matrix other$coefficients = other.getCoefficients();
            if (this$coefficients == null ? other$coefficients != null : !this$coefficients.equals(other$coefficients)) {
                return false;
            }
            Matrix this$coefficientsStde = this.getCoefficientsStde();
            Matrix other$coefficientsStde = other.getCoefficientsStde();
            if (this$coefficientsStde == null ? other$coefficientsStde != null : !this$coefficientsStde.equals(other$coefficientsStde)) {
                return false;
            }
            SarimaModel this$arima = this.getArima();
            SarimaModel other$arima = other.getArima();
            if (this$arima == null ? other$arima != null : !this$arima.equals(other$arima)) {
                return false;
            }
            SarimaModel this$arima0 = this.getArima0();
            SarimaModel other$arima0 = other.getArima0();
            if (this$arima0 == null ? other$arima0 != null : !this$arima0.equals(other$arima0)) {
                return false;
            }
            if (Double.compare(this.getNvar(), other.getNvar()) != 0) {
                return false;
            }
            DiffuseConcentratedLikelihood this$ll0 = this.getLl0();
            DiffuseConcentratedLikelihood other$ll0 = other.getLl0();
            if (this$ll0 == null ? other$ll0 != null : !this$ll0.equals(other$ll0)) {
                return false;
            }
            DiffuseConcentratedLikelihood this$ll = this.getLl();
            DiffuseConcentratedLikelihood other$ll = other.getLl();
            return !(this$ll == null ? other$ll != null : !this$ll.equals(other$ll));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TsDomain $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            Matrix $variables = this.getVariables();
            result = result * 59 + ($variables == null ? 43 : $variables.hashCode());
            Matrix $coefficients = this.getCoefficients();
            result = result * 59 + ($coefficients == null ? 43 : $coefficients.hashCode());
            Matrix $coefficientsStde = this.getCoefficientsStde();
            result = result * 59 + ($coefficientsStde == null ? 43 : $coefficientsStde.hashCode());
            SarimaModel $arima = this.getArima();
            result = result * 59 + ($arima == null ? 43 : $arima.hashCode());
            SarimaModel $arima0 = this.getArima0();
            result = result * 59 + ($arima0 == null ? 43 : $arima0.hashCode());
            long $nvar = Double.doubleToLongBits(this.getNvar());
            result = result * 59 + (int)($nvar >>> 32 ^ $nvar);
            DiffuseConcentratedLikelihood $ll0 = this.getLl0();
            result = result * 59 + ($ll0 == null ? 43 : $ll0.hashCode());
            DiffuseConcentratedLikelihood $ll = this.getLl();
            result = result * 59 + ($ll == null ? 43 : $ll.hashCode());
            return result;
        }

        public String toString() {
            return "TimeVaryingRegression.Results(domain=" + this.getDomain() + ", variables=" + this.getVariables() + ", coefficients=" + this.getCoefficients() + ", coefficientsStde=" + this.getCoefficientsStde() + ", arima=" + this.getArima() + ", arima0=" + this.getArima0() + ", nvar=" + this.getNvar() + ", ll0=" + this.getLl0() + ", ll=" + this.getLl() + ")";
        }

        static {
            MAPPING.delegate(ARIMA, SarimaInfo.getMapping(), r -> r.getArima());
            MAPPING.delegate("arima0", SarimaInfo.getMapping(), r -> r.getArima0());
            MAPPING.delegate(LL, DiffuseLikelihoodInfo.getMapping(), r -> r.getLl());
            MAPPING.delegate("likelihood0", DiffuseLikelihoodInfo.getMapping(), r -> r.getLl0());
            MAPPING.set("aic0", Double.class, r -> r.ll0.AIC(2));
            MAPPING.set("aic", Double.class, r -> r.ll.AIC(3));
            MAPPING.set("tdvar", Double.class, r -> r.getNvar());
            MAPPING.set(COEFF, Matrix.class, r -> r.getCoefficients());
            MAPPING.set(STDCOEFF, Matrix.class, r -> r.getCoefficientsStde());
            MAPPING.set(TD, Matrix.class, r -> r.getVariables());
            MAPPING.set(TDEFFECT, TsData.class, r -> {
                DataBlock tmp = new DataBlock(r.getDomain().getLength());
                DataBlock prod = new DataBlock(r.getDomain().getLength());
                for (int i = 0; i < r.variables.getColumnsCount(); ++i) {
                    prod.set(r.getCoefficients().column(i), r.getVariables().column(i), (a, b) -> a * b);
                    tmp.add(prod);
                }
                return new TsData(r.getDomain().getStart(), (IReadDataBlock)tmp);
            });
        }

        public static class ResultsBuilder {
            private TsDomain domain;
            private Matrix variables;
            private Matrix coefficients;
            private Matrix coefficientsStde;
            private SarimaModel arima;
            private SarimaModel arima0;
            private double nvar;
            private DiffuseConcentratedLikelihood ll0;
            private DiffuseConcentratedLikelihood ll;

            ResultsBuilder() {
            }

            public ResultsBuilder domain(TsDomain domain) {
                this.domain = domain;
                return this;
            }

            public ResultsBuilder variables(Matrix variables) {
                this.variables = variables;
                return this;
            }

            public ResultsBuilder coefficients(Matrix coefficients) {
                this.coefficients = coefficients;
                return this;
            }

            public ResultsBuilder coefficientsStde(Matrix coefficientsStde) {
                this.coefficientsStde = coefficientsStde;
                return this;
            }

            public ResultsBuilder arima(SarimaModel arima) {
                this.arima = arima;
                return this;
            }

            public ResultsBuilder arima0(SarimaModel arima0) {
                this.arima0 = arima0;
                return this;
            }

            public ResultsBuilder nvar(double nvar) {
                this.nvar = nvar;
                return this;
            }

            public ResultsBuilder ll0(DiffuseConcentratedLikelihood ll0) {
                this.ll0 = ll0;
                return this;
            }

            public ResultsBuilder ll(DiffuseConcentratedLikelihood ll) {
                this.ll = ll;
                return this;
            }

            public Results build() {
                return new Results(this.domain, this.variables, this.coefficients, this.coefficientsStde, this.arima, this.arima0, this.nvar, this.ll0, this.ll);
            }

            public String toString() {
                return "TimeVaryingRegression.Results.ResultsBuilder(domain=" + this.domain + ", variables=" + this.variables + ", coefficients=" + this.coefficients + ", coefficientsStde=" + this.coefficientsStde + ", arima=" + this.arima + ", arima0=" + this.arima0 + ", nvar=" + this.nvar + ", ll0=" + this.ll0 + ", ll=" + this.ll + ")";
            }
        }
    }
}

