/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.ExpTransformation;
import ec.tstoolkit.timeseries.simplets.ITsDataTransformation;
import ec.tstoolkit.timeseries.simplets.TsData;

public class LogTransformation
implements ITsDataTransformation {
    public boolean canTransform(TsData data) {
        return data.check(x -> Double.isFinite(x) ? x > 0.0 : true);
    }

    @Override
    public ITsDataTransformation converse() {
        return new ExpTransformation();
    }

    @Override
    public boolean transform(TsData data, ITsDataTransformation.LogJacobian ljacobian) {
        if (!this.canTransform(data)) {
            return false;
        }
        data.apply(x -> Math.log(x));
        if (ljacobian != null) {
            DataBlock rc = new DataBlock(data.internalStorage()).range(ljacobian.start, ljacobian.end);
            ljacobian.value -= rc.sum();
        }
        return true;
    }
}

