% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jregarima.R, R/regarima.R
\name{regarima}
\alias{regarima}
\alias{jregarima}
\alias{jregarima_tramoseats}
\alias{jregarima_x13}
\alias{regarima_tramoseats}
\alias{regarima_x13}
\title{RegARIMA model, pre-adjustment in X13 and TRAMO-SEATS}
\usage{
jregarima(series, spec = NA)

jregarima_tramoseats(
  series,
  spec = c("TRfull", "TR0", "TR1", "TR2", "TR3", "TR4", "TR5")
)

jregarima_x13(series, spec = c("RG5c", "RG0", "RG1", "RG2c", "RG3", "RG4c"))

regarima(series, spec = NA)

regarima_tramoseats(
  series,
  spec = c("TRfull", "TR0", "TR1", "TR2", "TR3", "TR4", "TR5")
)

regarima_x13(series, spec = c("RG5c", "RG0", "RG1", "RG2c", "RG3", "RG4c"))
}
\arguments{
\item{series}{a univariate time series}

\item{spec}{model specification. For the function:
\itemize{
\item \code{regarima}, object of class \code{c("regarima_spec","X13") or c("regarima_spec","TRAMO_SEATS")}).
See functions \code{\link{regarima_spec_x13} and \link{regarima_spec_tramoseats}}.
\item \code{regarima_x13}, predefined X13 'JDemetra+' model specification (see \emph{Details}). The default is "RG5c".
\item \code{regarima_tramoseats}, predefined TRAMO-SEATS 'JDemetra+' model specification (see \emph{Details}). The default is "TRfull".
}}
}
\value{
\code{jregarima/jregarima_x13/jregarima_tramoseats} return a \code{\link{jSA}} object. It contains the Java objects of the result of the preadjustment method without any formatting. Therefore the computation is faster than with \code{regarima/regarima_x13/regarima_tramoseats}. The results can the seasonal adjustment can be extract by \code{\link{get_indicators}}.

\code{regarima/regarima_x13/regarima_tramoseats} return an object of class \code{"regarima"} and sub-class \code{"X13"} or \code{"TRAMO_SEATS"}. \code{regarima_x13} returns an object of class \code{c("regarima","X13")} and \code{regarima_tramoseats} an object of class \code{c("regarima","TRAMO_SEATS")}.
For the function \code{regarima}, the sub-class of the object depends on the used method that is defined by the class of the \code{spec} object.

An object of class \code{"regarima"} is a list containing the following components:

\item{specification}{list with the model specification as defined by the \code{spec} argument. See also Value of the \code{\link{regarima_spec_x13}} and  \code{\link{regarima_spec_tramoseats}} functions.}

\item{arma}{vector with the orders of the autoregressive (AR), moving average (MA), seasonal AR and seasonal MA processes, as well as with the regular and seasonal differencing orders (P,D,Q) (BP,BD,BQ).}

\item{arima.coefficients}{ matrix with the regular and seasonal AR and MA coefficients. The matrix contains the estimated coefficients, standard errors and t-statistics values. The estimated coefficients can be also extracted with the function \code{\link[stats]{coef}} (the output includes also the regression coefficients).}

\item{regression.coefficients}{ matrix with the regression variables (i.e.: mean, calendar effect, outliers and user-defined regressors) coefficients. The matrix contains the estimated coefficients, standard errors and t-statistics values. The estimated coefficients can be also extracted with the function \code{\link[stats]{coef}} (output includes also the arima coefficients). }

\item{loglik}{ matrix containing the log-likelihood of the RegARIMA model as well as the associated model selection criteria statistics (AIC, AICC, BIC and BICC) and parameters (\code{np} = number of parameters in the likelihood, \code{neffectiveobs} = number of effective observations in the likelihood). These statistics can be also extracted with the function \code{\link[stats]{logLik}}.}

\item{model}{list containing the information on the model specification after its estimation (\code{spec_rslt}), as well as the decomposed elements of the input series (ts matrix, \code{effects}). The model specification includes the information on the estimation method (\code{Model}) and time span (\code{T.span}), whether the original series was log transformed (\code{Log transformation}) and details on the regression part of the RegARIMA model; i.e. if it includes a \code{Mean}, \code{Trading days} effects (if yes, it provides the number of regressors), \code{Leap year} effect, \code{Easter} effect and whether outliers were detected (\code{Outliers}; if yes, it provides the number of outliers). The decomposed elements of the input series contain the linearised series (\code{y_lin}) and the deterministic components; i.e.: trading days effect (\code{tde}), Easter effect (\code{ee}), other moving holidays effect (\code{omhe}) and outliers effect (total - \code{out}, related to irregular - \code{out_i}, related to trend - \code{out_t}, related to seasonal - \code{out_s}).}

\item{residuals}{ the residuals (time series). They can be also extracted with the function \code{\link[stats]{residuals}}.}

\item{residuals.stat}{List containing statistics on the RegARIMA residuals. It provides residuals standard error (\code{st.error}) and results for the tests on the normality, independence and linearity of the residuals (\code{tests}) - object of class \code{c("regarima_rtests","data.frame")}.}

\item{forecast}{ts matrix containing the forecast of the original series (\code{fcst}) and it's standard error (\code{fcsterr}).}
}
\description{
\code{regarima/regarima_x13/regarima_tramoseats} decomposes the time series in a linear deterministic component and in a stochastic component. The deterministic part of the series can contain outliers, calendar effects and regression effects. The stochastic part is defined by a seasonal multiplicative ARIMA model, as discussed by BOX, G.E.P., and JENKINS, G.M. (1970).
\code{jregarima/jregarima_x13/jregarima_tramoseats} does the same computation but returns the Java objects without formatting the output
}
\details{
In the X13 and TRAMO-SEATS seasonal adjustment the first step consists of pre-adjusting the original series with a RegARIMA model, where the original series is corrected for any deterministic effects and missing observations. This step is also referred as linearization of the original series.

The RegARIMA model (model with ARIMA errors) is specified as below.

\deqn{z_t=y_t\beta+x_t}

where:
\itemize{
\item \eqn{z_t} - is the original series;
\item \eqn{\beta = (\beta_1,...,\beta_n)} - a vector of regression coefficients;
\item \eqn{y_t = (y_{1t},...,y_{nt})} - \eqn{n} regression variables (outliers, calendar effects, user-defined variables);
\item \eqn{x_t} - a disturbance that follows the general ARIMA process:
\eqn{\phi(B)\delta(B)x_t=\theta(B)a_t}; \eqn{\phi(B), \delta(B)} and \eqn{\theta(B)} are the finite polynomials in \eqn{B}; \eqn{a_t} is a white-noise variable with zero mean and a constant variance.
}

The polynomial \eqn{\phi(B)} is a stationary autoregressive (AR) polynomial in \eqn{B}, which is a product of the stationary regular AR polynomial in \eqn{B} and the stationary seasonal polynomial in \eqn{B^s}:

\deqn{\phi(B)=\phi_p(B)\Phi_{bp}(B^s)=(1+\phi_1B+...+\phi_pB^p)(1+\Phi_1B^s+...+\Phi_{bp}B^{bps})}

where:
\itemize{
\item \eqn{p} - number of regular AR terms (here and in 'JDemetra+' \eqn{p \le 3});
\item \eqn{bp} - number of seasonal AR terms (here and in 'JDemetra+' \eqn{bp \le 1});
\item \eqn{s} - number of observations per year (frequency of the time series).
}

The polynomial \eqn{\theta(B)} is an invertible moving average (MA) polynomial in \eqn{B}, which is a product of the invertible regular MA polynomial in \eqn{B} and the invertible seasonal MA polynomial in \eqn{B^s}:

\deqn{\theta(B)=\theta_q(B)\Theta_{bq}(B^s)=(1+\theta_1B+...+\theta_qB^q)(1+\Theta_1B^s+...+\Theta_{bq}B^{bqs})}

where:
\itemize{
\item \eqn{q} - number of regular MA terms (here and in 'JDemetra+' \eqn{q \le 3});
\item \eqn{bq} - number of seasonal MA terms (here and in 'JDemetra+' \eqn{bq \le 1});
}

The polynomial \eqn{\delta(B)} is the non-stationary AR polynomial in \eqn{B} (unit roots):

\deqn{\delta(B)=(1-B)^d(1-B^s)^{d_s}}

where:
\itemize{
\item \eqn{d} - regular differencing order (here and in 'JDemetra+' \eqn{d \le 1});
\item \eqn{d_s} - seasonal differencing order (here and in 'JDemetra+' \eqn{d_s \le 1});
}

Notations used for AR and MA processes, model denoted as ARIMA \eqn{(P,D,Q)(BP,BD,BQ)}, are consistent with those in 'JDemetra+'.

As regards the available predefined 'JDemetra+' X13 and TRAMO-SEATS model specifications, they are described in the tables below.

\strong{X13:}
\tabular{rrrrrrr}{
\strong{Identifier} |\tab \strong{Log/level detection} |\tab \strong{Outliers detection} |\tab \strong{Calendar effects} |\tab \strong{ARIMA}\cr
RG0 |\tab \emph{NA} |\tab \emph{NA} |\tab \emph{NA} |\tab Airline(+mean)\cr
RG1 |\tab automatic |\tab AO/LS/TC  |\tab \emph{NA} |\tab Airline(+mean)\cr
RG2c |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab Airline(+mean)\cr
RG3 |\tab automatic |\tab AO/LS/TC |\tab \emph{NA} |\tab automatic\cr
RG4c |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab automatic\cr
RG5c |\tab automatic |\tab AO/LS/TC |\tab 7 td vars + Easter |\tab automatic
}

\strong{TRAMO-SEATS:}
\tabular{rrrrrrrr}{
\strong{Identifier} |\tab \strong{Log/level detection} |\tab \strong{Outliers detection} |\tab \strong{Calendar effects} |\tab \strong{ARIMA}\cr
TR0 |\tab \emph{NA} |\tab \emph{NA} |\tab \emph{NA} |\tab Airline(+mean)\cr
TR1 |\tab automatic |\tab AO/LS/TC |\tab \emph{NA} |\tab Airline(+mean)\cr
TR2 |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab Airline(+mean)\cr
TR3 |\tab automatic |\tab AO/LS/TC |\tab \emph{NA} |\tab automatic\cr
TR4 |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab automatic\cr
TR5 |\tab automatic |\tab AO/LS/TC |\tab 7 td vars + Easter |\tab automatic\cr
TRfull |\tab automatic |\tab AO/LS/TC |\tab automatic |\tab automatic
}
}
\examples{
\donttest{
 # X13 method
myseries <- ipi_c_eu[, "FR"]
myreg <- regarima_x13(myseries, spec ="RG5c")
summary(myreg)
plot(myreg)

myspec1 <- regarima_spec_x13(myreg, tradingdays.option = "WorkingDays")
myreg1 <- regarima(myseries, myspec1)

myspec2 <- regarima_spec_x13(myreg, usrdef.outliersEnabled = TRUE,
             usrdef.outliersType = c("LS", "AO"),
             usrdef.outliersDate = c("2008-10-01", "2002-01-01"),
             usrdef.outliersCoef = c(36, 14),
             transform.function = "None")
myreg2 <- regarima(myseries, myspec2)
myreg2

myspec3 <- regarima_spec_x13(myreg, automdl.enabled = FALSE,
             arima.p = 1, arima.q = 1,
             arima.bp = 0, arima.bq = 1,
             arima.coefEnabled = TRUE,
             arima.coef = c(-0.8, -0.6, 0),
             arima.coefType = c(rep("Fixed", 2), "Undefined"))
s_arimaCoef(myspec3)
myreg3 <- regarima(myseries, myspec3)
summary(myreg3)
plot(myreg3)

 # TRAMO-SEATS method
myspec <- regarima_spec_tramoseats("TRfull")
myreg <- regarima(myseries, myspec)
myreg

myspec2 <- regarima_spec_tramoseats(myspec, tradingdays.mauto = "Unused",
             tradingdays.option = "WorkingDays",
             easter.type = "Standard",
             automdl.enabled = FALSE, arima.mu = TRUE)
myreg2 <- regarima(myseries, myspec2)

var1 <- ts(rnorm(length(myseries))*10, start = start(myseries), frequency = 12)
var2 <- ts(rnorm(length(myseries))*100, start = start(myseries), frequency = 12)
var <- ts.union(var1, var2)
myspec3 <- regarima_spec_tramoseats(myspec,
             usrdef.varEnabled = TRUE, usrdef.var = var)
s_preVar(myspec3)
myreg3 <- regarima(myseries, myspec3)
myreg3
}
}
\references{
Info on 'JDemetra+', usage and functions:
\url{https://ec.europa.eu/eurostat/cros/content/documentation_en}

BOX G.E.P. and JENKINS G.M. (1970), "Time Series Analysis: Forecasting and Control", Holden-Day, San Francisco.

BOX G.E.P., JENKINS G.M., REINSEL G.C. and LJUNG G.M. (2015), "Time Series Analysis: Forecasting and Control", John Wiley & Sons, Hoboken, N. J., 5th edition.
}
