/*
 * Decompiled with CFR 0.152.
 */
package demetra.xml.calendar;

import demetra.xml.IXmlConverter;
import demetra.xml.calendar.AbstractXmlCalendar;
import demetra.xml.calendar.XmlChainedCalendar;
import demetra.xml.calendar.XmlCompositeCalendar;
import demetra.xml.calendar.XmlNationalCalendar;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.utilities.Arrays2;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="calendars")
@XmlType(name="calendarsType")
public class XmlCalendars
implements IXmlConverter<GregorianCalendarManager> {
    static final String NAME = "calendarsType";
    static final String RNAME = "calendars";
    @XmlElements(value={@XmlElement(name="nationalCalendar", type=XmlNationalCalendar.class), @XmlElement(name="compositeCalendar", type=XmlCompositeCalendar.class), @XmlElement(name="chainedCalendar", type=XmlChainedCalendar.class)})
    public AbstractXmlCalendar[] calendars;

    public boolean copyTo(GregorianCalendarManager mgr) {
        boolean rslt = true;
        if (this.calendars != null) {
            for (int i = 0; i < this.calendars.length; ++i) {
                if (this.calendars[i].addTo(mgr)) continue;
                rslt = false;
            }
        }
        return rslt;
    }

    public boolean isEmpty() {
        return Arrays2.isNullOrEmpty((Object[])this.calendars);
    }

    @Override
    public GregorianCalendarManager create() {
        GregorianCalendarManager mgr = new GregorianCalendarManager();
        this.copyTo(mgr);
        return mgr;
    }

    @Override
    public void copy(GregorianCalendarManager mgr) {
        String[] names = mgr.getNames();
        ArrayList<XmlNationalCalendar> tmp = new ArrayList<XmlNationalCalendar>();
        for (int i = 0; i < names.length; ++i) {
            String code = names[i];
            if (code.equals("Default")) continue;
            AbstractXmlCalendar xcal = XmlNationalCalendar.create(code, mgr);
            if (xcal == null) {
                xcal = XmlChainedCalendar.create(code, mgr);
            }
            if (xcal == null) {
                xcal = XmlCompositeCalendar.create(code, mgr);
            }
            tmp.add((XmlNationalCalendar)xcal);
        }
        this.calendars = (AbstractXmlCalendar[])Jdk6.Collections.toArray(tmp, AbstractXmlCalendar.class);
    }
}

