/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.eco.GlsForecast;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DiffuseVarianceFilter;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.FilteredData;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.utilities.Arrays2;

public class SsfGlsForecast
extends GlsForecast {
    public <F extends ISsf> void calcForecast(double[] y, double evar, F ssf, int nf) {
        this.m_nf = nf;
        if (this.m_nf <= 0) {
            return;
        }
        this.m_ef = new double[this.m_nf];
        this.m_f = new double[this.m_nf];
        int n = y.length;
        Filter<F> filter = new Filter<F>();
        filter.setSsf(ssf);
        DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
        frslts.getFilteredData().setSavingA(true);
        double[] yc = new double[n + this.m_nf];
        Arrays2.copy(y, yc, n);
        for (int i = n; i < yc.length; ++i) {
            yc[i] = Double.NaN;
        }
        SsfData ssfy = new SsfData(yc, null);
        filter.process(ssfy, frslts);
        DiffuseVarianceFilter vfilter = frslts.getVarianceFilter();
        FilteredData fdata = frslts.getFilteredData();
        for (int i = 0; i < this.m_nf; ++i) {
            this.m_f[i] = fdata.A(n + i).get(0);
            this.m_ef[i] = vfilter.F(n + i) * evar;
        }
    }

    public <F extends ISsf> void calcForecast(double[] y, Matrix x, double evar, double[] c, Matrix cvar, F ssf, Matrix fx) {
        int nx = c.length;
        this.m_nf = fx.getRowsCount();
        if (this.m_nf <= 0) {
            return;
        }
        this.m_ef = new double[this.m_nf];
        this.m_f = new double[this.m_nf];
        int n = y.length;
        Filter<F> filter = new Filter<F>();
        filter.setSsf(ssf);
        DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
        frslts.getFilteredData().setSavingA(true);
        double[] yc = new double[n + this.m_nf];
        Arrays2.copy(y, yc, n);
        for (int i = n; i < yc.length; ++i) {
            yc[i] = Double.NaN;
        }
        SsfData ssfy = new SsfData(yc, null);
        filter.process(ssfy, frslts);
        DiffuseVarianceFilter vfilter = frslts.getVarianceFilter();
        FilteredData fdata = frslts.getFilteredData();
        for (int i = 0; i < this.m_nf; ++i) {
            this.m_f[i] = fdata.A(n + i).get(0);
            this.m_ef[i] = vfilter.F(n + i) * evar;
        }
        int pos = ssf.getNonStationaryDim();
        double[] xcur = new double[n + this.m_nf];
        Matrix xe = new Matrix(this.m_nf, nx);
        for (int i = 0; i < nx; ++i) {
            x.column(i).copyTo(xcur, 0);
            fx.column(i).copyTo(xcur, n);
            vfilter.process(fdata, pos, xcur, null);
            for (int j = 0; j < this.m_nf; ++j) {
                xe.set(j, i, fdata.E(n + j));
            }
        }
        DataBlock C = new DataBlock(c);
        DataBlockIterator xrows = xe.rows();
        DataBlock xrow = xrows.getData();
        do {
            int n2 = xrows.getPosition();
            this.m_f[n2] = this.m_f[n2] + xrow.dot(C);
            int n3 = xrows.getPosition();
            this.m_ef[n3] = this.m_ef[n3] + SymmetricMatrix.quadraticForm(cvar, xrow);
        } while (xrows.next());
        for (int i = 0; i < this.m_ef.length; ++i) {
            this.m_ef[i] = Math.sqrt(this.m_ef[i]);
        }
    }
}

