/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.design.AlgorithmDefinition;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Arrays;

@AlgorithmDefinition
public interface ISingleOutlierDetector<T extends IArimaModel> {
    public static double calcVA(int nval) {
        return ISingleOutlierDetector.calcVA(nval, 0.05);
    }

    public static double calcVA(int nvals, double alpha) {
        int i;
        Normal normal = new Normal();
        if (nvals == 1) {
            return normal.getProbabilityInverse(alpha / 2.0, ProbabilityType.Upper);
        }
        double n = nvals;
        double[] y = new double[3];
        int[] x = new int[]{2, 100, 200};
        Matrix X = new Matrix(3, 3);
        for (i = 0; i < 3; ++i) {
            X.set(i, 0, 1.0);
            X.set(i, 2, Math.sqrt(2.0 * Math.log(x[i])));
            X.set(i, 1, (Math.log(Math.log(x[i])) + Math.log(Math.PI * 4)) / (2.0 * X.get(i, 2)));
        }
        y[0] = normal.getProbabilityInverse((1.0 + Math.sqrt(1.0 - alpha)) / 2.0, ProbabilityType.Lower);
        for (i = 1; i < 3; ++i) {
            y[i] = ISingleOutlierDetector.calcVAL(x[i], alpha);
        }
        Householder qr = new Householder(false);
        qr.decompose(X);
        double[] b = qr.solve(y);
        double acv = Math.sqrt(2.0 * Math.log(n));
        double bcv = (Math.log(Math.log(n)) + Math.log(Math.PI * 4)) / (2.0 * acv);
        return b[0] + b[1] * bcv + b[2] * acv;
    }

    public static double calcVAL(int nvals, double alpha) {
        if (nvals == 1) {
            return 1.96;
        }
        double n = nvals;
        double pmod = 2.0 - Math.sqrt(1.0 + alpha);
        double acv = Math.sqrt(2.0 * Math.log(n));
        double bcv = acv - (Math.log(Math.log(n)) + Math.log(Math.PI * 4)) / (2.0 * acv);
        double xcv = -Math.log(-0.5 * Math.log(pmod));
        return xcv / acv + bcv;
    }

    public void addOutlierFactory(IOutlierFactory var1, double var2);

    public static double calcMAD(IReadDataBlock e, int centile) {
        int n = e.getLength();
        double[] a = new double[n];
        e.copyTo(a, 0);
        for (int i = 0; i < n; ++i) {
            a[i] = Math.abs(a[i]);
        }
        Arrays.sort(a);
        double m = 0.0;
        int nm = n * centile / 100;
        m = n % 2 == 0 ? (a[nm - 1] + a[nm]) / 2.0 : a[nm];
        Normal normal = new Normal();
        double l = normal.getProbabilityInverse(0.5 + 0.005 * (double)centile, ProbabilityType.Lower);
        return m / l;
    }

    public void clearOutlierFactories();

    public double coeff(int var1, int var2);

    public void exclude(int var1, int var2);

    public void allow(int var1, int var2);

    public void exclude(int[] var1);

    public void exclude(IOutlierVariable var1);

    public void allow(IOutlierVariable var1);

    default public void exclude(IOutlierVariable[] outliers) {
        for (IOutlierVariable o : outliers) {
            this.exclude(o);
        }
    }

    default public void exclude(TsPeriod pos, int ioutlier) {
        int r = pos.minus(this.getDomain().getStart());
        if (r >= 0) {
            this.exclude(r, ioutlier);
        }
    }

    public TsDomain getDomain();

    public IOutlierVariable getMaxOutlier();

    public double getMaxTStat();

    public int getOutlierFactoriesCount();

    public IOutlierFactory getOutlierFactory(int var1);

    public boolean process(RegArimaModel<T> var1, TsDomain var2, TsDomain var3);

    public double T(int var1, int var2);
}

