/*
 * Decompiled with CFR 0.152.
 */
package com.nexr.rhive.hive.udf;

import com.nexr.rhive.hive.HiveVariations;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

public class ScaleUDF
extends GenericUDF {
    ObjectInspectorConverters.Converter[] converters;
    DoubleObjectInspector scaleFieldOI;

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        double value = Double.parseDouble(this.converters[0].convert(arguments[0].get()).toString());
        double average = Double.parseDouble(this.converters[1].convert(arguments[1].get()).toString());
        double std = Double.parseDouble(this.converters[2].convert(arguments[2].get()).toString());
        if (std != 0.0) {
            double scale = (value - average) / std;
            return new DoubleWritable(scale);
        }
        return null;
    }

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int i;
        if (arguments.length != 3) {
            throw new UDFArgumentLengthException("The function scale accepts exactly 3 arguments.");
        }
        for (i = 0; i < arguments.length; ++i) {
            ObjectInspector.Category category = arguments[i].getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal((int)(i + 1)) + " argument of function LOCATE is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        for (i = 0; i < arguments.length; ++i) {
            String typeName = arguments[i].getTypeName();
            try {
                if (typeName.equals(HiveVariations.getFieldValue(HiveVariations.serdeConstants, "INT_TYPE_NAME"))) {
                    this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                    continue;
                }
                if (typeName.equals(HiveVariations.getFieldValue(HiveVariations.serdeConstants, "DOUBLE_TYPE_NAME"))) {
                    this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                    continue;
                }
                if (typeName.equals(HiveVariations.getFieldValue(HiveVariations.serdeConstants, "FLOAT_TYPE_NAME"))) {
                    this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
                    continue;
                }
                if (typeName.equals(HiveVariations.getFieldValue(HiveVariations.serdeConstants, "BIGINT_TYPE_NAME"))) {
                    this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                    continue;
                }
                throw new IllegalArgumentException("can't support this type : " + typeName);
            }
            catch (Exception e) {
                throw new UDFArgumentException((Throwable)e);
            }
        }
        this.scaleFieldOI = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        return this.scaleFieldOI;
    }

    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("scale(");
        for (int i = 0; i < children.length; ++i) {
            sb.append(children[i]);
            if (i + 1 == children.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

