\name{reservoirRouting.base}
\alias{reservoirRouting.base}
\title{
base function for class of \code{reservoirRouting}
}
\description{
function for routing flood through a reservoir using classical Muskingum technique
}
\usage{
\method{reservoirRouting}{base}(inflow, geometry,initialStorage,simulation)
}
\arguments{
  \item{inflow}{a vector of in (cms) presenting a runoff event generated by excess rainfall computed by \code{loss} methods or an object inherited from any of the following classes :{\code{transform} ; \code{reachRouting} ; \code{reservoirRouting}}.}
  \item{geometry}{a list of geometric specifications of the reservoir:
     \itemize{
         \item \code{storageElevationCurve}: a data frame: a data frame at which its first collumn includes height (masl) and second collums presents equivalant volume to the height at first collumn (MCM)
         \item \code{dischargeElevationCurve}: a data frame: a data frame at which its first collumn includes height (masl) and second collums presents equivalant discharge rate to the height at first collumn (cms)
         \item \code{storage}: the maximum volume of reservoir capacity (MCM)
     }
  }
  \item{initialStorage}{(optional) the initial storage of reservoir at the first time step of simulation (MCM). default to the capacity.}
  \item{simulation}{a list of simulation time and dates as below:
     \itemize{
         \item \code{start}: the date which simulation starts, must be in \code{'YYYY-MM-DD'} format
         \item \code{start}: the date which simulation ends, must be in \code{'YYYY-MM-DD'} format
         \item \code{by}: the interval of each steps in seconds
     }
  }
}
\value{
a data.frame:  including inflow time series and routing resaults
}
\references{
Chow, V. T., Maidment, D. R., & Mays, L. W. (1988). Applied hydrology.
}
\seealso{ \code{\link[RHMS]{reservoirRouting}} }
\author{
Rezgar Arabzadeh
}
\keyword{ list }
