% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_steps.R
\name{.assignGibbsFUN}
\alias{.assignGibbsFUN}
\title{Assigns the appropriate function and its input variables for the Gibbs procedure.}
\usage{
.assignGibbsFUN(
  loc,
  type,
  trend,
  cycle,
  cubsAR,
  cycleLag,
  errorARMA,
  exoNames = NULL
)
}
\arguments{
\item{loc}{A data frame containing information on each involved parameter, for instance
its corresponding system matrix, variable names, and parameter restrictions.}

\item{type}{A character string specifying the type of the Phillip's curve.
\code{type = "TKP"} denotes the traditional Keynesian Phillip's curve and
\code{type = "NKP"} the New Keynesian Phillip's curve, see details. The default is
\code{type = "TKP"}.}

\item{trend}{A character string specifying the trend model. \code{trend = "RW1"} denotes
a first order random walk, \code{trend = "RW2"} a second order random walk (local linear
trend) and \code{trend = "DT"} a damped trend model. The default is \code{trend = "DT"}.}

\item{cycle}{A character string specifying the cycle model. \code{cycle = "AR1"} denotes
an AR(1) process, \code{cycle = "AR2"} an AR(2) process, \code{cycle = "RAR2"} a
reparametrized AR(2) process. The default is \code{cycle = "AR2"}.}

\item{cubsAR}{A non-negative integer specifying the maximum CUBS lag that is included
in the CUBS equation. The default is \code{cubsAR = 0}, see details.}

\item{cycleLag}{A non-negative integer specifying the maximum cycle lag that is included
in the CUBD equation. The default is \code{cycleLag = 0}, see details.}

\item{errorARMA}{A vector with non-negative integers specifying the AR
and MA degree of the error term in the second observation equation.}

\item{exoNames}{A character vector containing the names of the exogenous variables.}
}
\description{
Assigns the appropriate function and its input variables for the Gibbs procedure.
}
\keyword{internal}
