% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/profiles.R
\name{get_profile}
\alias{get_profile}
\title{Gets a view (profile) to which the user has access to}
\usage{
get_profile(account.id, webproperty.id, profile.id, token)
}
\arguments{
\item{account.id}{integer or character. Account ID to retrieve the goal for.}

\item{webproperty.id}{character. Web property ID to retrieve the goal for.}

\item{profile.id}{View (Profile) ID to retrieve the goal for.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An Analytics view (profile).
\item{id}{View (Profile) ID.}
\item{kind}{Resource type for Analytics view (profile).}
\item{self.link}{Link for this view (profile).}
\item{account.id}{Account ID to which this view (profile) belongs.}
\item{webproperty.id}{Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.}
\item{internal.webproperty.id}{Internal ID for the web property to which this view (profile) belongs.}
\item{name}{Name of this view (profile).}
\item{currency}{The currency type associated with this view (profile).}
\item{timezone}{Time zone for which this view (profile) has been configured. Time zones are identified by strings from the TZ database.}
\item{website.url}{Website URL for this view (profile).}
\item{site.search.query.parameters}{The site search query parameters for this view (profile).}
\item{strip.site.search.query.parameters}{Whether or not Analytics will strip search query parameters from the URLs in your reports.}
\item{type}{View (Profile) type. Supported types: WEB or APP.}
\item{permissions}{Permissions the user has for this view (profile).}
\item{created}{Time this view (profile) was created.}
\item{updated}{Time this view (profile) was last modified.}
\item{e.commerce.tracking}{Indicates whether ecommerce tracking is enabled for this view (profile).}
\item{parent.link}{Parent link for this view (profile). Points to the web property to which this view (profile) belongs.}
\item{child.link}{Child link for this view (profile). Points to the list of goals for this view (profile).}#'
}
\description{
Gets a view (profile) to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/profiles}{Google Management API - Views (Profiles)}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_goal}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_webproperties}}
}

