/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.initialization.booleanfunction;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractMultiObjectiveFitnessFunction;
import freak.core.fitness.MultiObjectiveFitnessFunction;
import freak.core.graph.Initialization;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.BooleanFunctionGenotype;
import freak.module.searchspace.logictree.Data;
import java.util.Iterator;

public class AllLiterals
extends Initialization
implements Configurable {
    private boolean exclude = false;

    public AllLiterals(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(this.graph.getSchedule().getGenotypeSearchSpace() instanceof BooleanFunction)) {
            throw new UnsupportedEnvironmentException("Works only on the SearchSpace Boolean Function.");
        }
    }

    public IndividualList[] process(IndividualList[] origin) {
        IndividualList[] result = new IndividualList[1];
        BooleanFunction sp = (BooleanFunction)this.graph.getSchedule().getGenotypeSearchSpace();
        result[0] = new Population(this.graph.getSchedule());
        BooleanFunctionGenotype firstGeno = (BooleanFunctionGenotype)sp.getRandomGenotype();
        result[0].addIndividual(new Individual(this.graph.getSchedule(), sp.getLiteral(0), null));
        int i = 1;
        while (i < Data.getNumCompareNodes()) {
            MultiObjectiveFitnessFunction ff = (MultiObjectiveFitnessFunction)this.getOperatorGraph().getSchedule().getFitnessFunction();
            Individual individual = new Individual(this.graph.getSchedule(), sp.getLiteral(i), null);
            if (i % 1000 == 0) {
                System.out.println(String.valueOf(i) + " " + individual.toString());
            }
            if (this.exclude) {
                double[] fitness = ff.evaluate(individual, result[0]);
                Iterator it = result[0].iterator();
                int[] comp = new int[result[0].size()];
                boolean add = true;
                int j = 0;
                while (it.hasNext()) {
                    Individual ind = (Individual)it.next();
                    double[] fitness2 = ff.evaluate(ind, result[0]);
                    comp[j] = AbstractMultiObjectiveFitnessFunction.compare(fitness2, fitness);
                    if (comp[j] >= 0) {
                        add = false;
                        break;
                    }
                    ++j;
                }
                if (add) {
                    Population pop = new Population(this.getOperatorGraph().getSchedule());
                    pop.addIndividual(individual);
                    it = result[0].iterator();
                    j = 0;
                    while (it.hasNext()) {
                        Individual ind = (Individual)it.next();
                        if (comp[j] == -2) {
                            pop.addIndividual(ind);
                        }
                        ++j;
                    }
                    result[0] = pop;
                }
            } else {
                result[0].addIndividual(new Individual(this.graph.getSchedule(), sp.getLiteral(i), null));
            }
            ++i;
        }
        return result;
    }

    public Boolean getPropertyExclude() {
        return new Boolean(this.exclude);
    }

    public void setPropertyExclude(Boolean value) {
        this.exclude = value;
    }

    public String getLongDescriptionForExclude() {
        return "Exclude dominated literals?";
    }

    public String getName() {
        return "All Literals";
    }

    public String getDescription() {
        return "Creates all possible (non-dominated) literals";
    }
}

