/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.view.SingleIndividualView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.fitness.graphedgeselection.AbstractMSTFitnessFunction;
import freak.module.fitness.graphedgeselection.MSTFitnessFunctionInterface;
import freak.module.searchspace.GraphEdgeSelection;
import freak.module.searchspace.GraphEdgeSelectionGenotype;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class EdgeSelectionView
extends SingleIndividualView
implements Configurable,
FreakSwingModel {
    private boolean displayNodeNumbers = false;
    private boolean displayEdgeWeights = false;
    private boolean displayUnselectedEdges = true;
    private Color nodeNumberColor = Color.blue;
    private Color edgeWeightColor = Color.lightGray;
    private Color nodeColor = Color.red;
    private Color selectedEdgeColor = Color.darkGray;
    private Color unselectedEdgeColor = new Color(204, 255, 204);

    public EdgeSelectionView(Schedule schedule) {
        super(schedule);
        this.setDisplayStrategy(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getPhenotypeSearchSpace() instanceof GraphEdgeSelection)) {
            throw new UnsupportedEnvironmentException("Unsupported search space");
        }
        if (schedule.getRealFitnessFunction() instanceof AbstractMSTFitnessFunction) {
            this.displayEdgeWeights = true;
        }
        this.setDisplayStrategy(1);
    }

    public JPanel createIndividualPanel() {
        return new ESPanel(this);
    }

    public String getName() {
        return "Edge Selection View";
    }

    public String getDescription() {
        return "Graphical view of an edge selection.";
    }

    public Class[] getInputDataTypes() {
        return new Class[]{IndividualList.class};
    }

    public void setPropertyDisplayNumbers(Boolean dn) {
        this.displayNodeNumbers = dn;
        UpdateManager.markDirty(this);
    }

    public Boolean getPropertyDisplayNumbers() {
        return new Boolean(this.displayNodeNumbers);
    }

    public String getShortDescriptionForDisplayNumbers() {
        return "Display node numbers";
    }

    public String getLongDescriptionForDisplayNumbers() {
        return "Displays the numbers for all nodes.";
    }

    public void setPropertyDisplayEdgeWeights(Boolean dn) {
        this.displayEdgeWeights = dn;
        UpdateManager.markDirty(this);
    }

    public Boolean getPropertyDisplayEdgeWeights() {
        return new Boolean(this.displayEdgeWeights);
    }

    public String getShortDescriptionForDisplayEdgeWeights() {
        return "Display edge weights";
    }

    public String getLongDescriptionForDisplayEdgeWeights() {
        return "Displays the weight for all edges.";
    }

    public void setPropertyDisplayUnselectedEdges(Boolean dn) {
        this.displayUnselectedEdges = dn;
        UpdateManager.markDirty(this);
    }

    public Boolean getPropertyDisplayUnselectedEdges() {
        return new Boolean(this.displayUnselectedEdges);
    }

    public String getShortDescriptionForDisplayUnselectedEdges() {
        return "Display unselected edges";
    }

    public String getLongDescriptionForDisplayUnselectedEdges() {
        return "This view will draw all edges, including the unselected edges.";
    }

    public void setPropertyNumberColor(Color color) {
        if (color != null) {
            this.nodeNumberColor = color;
            UpdateManager.markDirty(this);
        }
    }

    public Color getPropertyNumberColor() {
        return this.nodeNumberColor;
    }

    public String getShortDescriptionForNumberColor() {
        return "Node numbers color";
    }

    public String getLongDescriptionForNumberColor() {
        return "Sets the color for the displayed node numbers.";
    }

    public void setPropertyEdgeWeightColor(Color color) {
        if (color != null) {
            this.edgeWeightColor = color;
            UpdateManager.markDirty(this);
        }
    }

    public Color getPropertyEdgeWeightColor() {
        return this.edgeWeightColor;
    }

    public String getShortDescriptionForEdgeWeightColor() {
        return "Edge weight color";
    }

    public String getLongDescriptionForEdgeWeightColor() {
        return "Sets the color for the displayed edge weights.";
    }

    public void setPropertyPointColor(Color color) {
        if (color != null) {
            this.nodeColor = color;
            UpdateManager.markDirty(this);
        }
    }

    public Color getPropertyPointColor() {
        return this.nodeColor;
    }

    public String getShortDescriptionForPointColor() {
        return "Color of the nodes";
    }

    public String getLongDescriptionForPointColor() {
        return "Sets the color for the displayed nodes.";
    }

    public void setPropertySelectedEdgeColor(Color color) {
        if (color != null) {
            this.selectedEdgeColor = color;
            UpdateManager.markDirty(this);
        }
    }

    public Color getPropertySelectedEdgeColor() {
        return this.selectedEdgeColor;
    }

    public String getShortDescriptionForSelectedEdgeColor() {
        return "Selected edges color";
    }

    public String getLongDescriptionForSelectedEdgeColor() {
        return "Sets the color for the selected edges.";
    }

    public void setPropertyUnselectedEdgeColor(Color color) {
        if (color != null) {
            this.unselectedEdgeColor = color;
            UpdateManager.markDirty(this);
        }
    }

    public Color getPropertyUnselectedEdgeColor() {
        return this.unselectedEdgeColor;
    }

    public String getShortDescriptionForUnselectedEdgeColor() {
        return "Unselected edges color";
    }

    public String getLongDescriptionForUnselectedEdgeColor() {
        return "Sets the color for the unselected edges.";
    }

    class ESPanel
    extends JPanel {
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private Graphics graphics;
        private EdgeSelectionView esview;

        public ESPanel(EdgeSelectionView esview) {
            this.esview = esview;
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            EdgeSelectionView edgeSelectionView = this.esview;
            synchronized (edgeSelectionView) {
                Individual individual = EdgeSelectionView.this.getIndividualToDisplay();
                if (individual != null) {
                    int node2;
                    int node1;
                    GraphEdgeSelection.Graph.Edge edge;
                    GraphEdgeSelectionGenotype gesGenotype = (GraphEdgeSelectionGenotype)individual.getPhenotype();
                    GraphEdgeSelection.Graph graph = gesGenotype.getGraph();
                    String infotext = null;
                    if (EdgeSelectionView.this.schedule.getRealFitnessFunction() instanceof MSTFitnessFunctionInterface) {
                        int numEdgesMinusN = graph.getNumberOfSelectedEdges(gesGenotype) - graph.getNumberOfNodes();
                        String numEdgesMinusNString = "";
                        if (numEdgesMinusN < 0) {
                            numEdgesMinusNString = "" + numEdgesMinusN;
                        } else if (numEdgesMinusN > 0) {
                            numEdgesMinusNString = "+" + numEdgesMinusN;
                        }
                        infotext = "Edge Weights: " + graph.getSumOfWeightsOfAllSelectedEdges(gesGenotype) + " (" + graph.weightOfMST() + ") Selected Edges: n" + numEdgesMinusNString + ", Con. Components: " + graph.numOfConnectedComponentsForSelectedEdges(gesGenotype);
                    }
                    if (infotext == null && EdgeSelectionView.this.schedule.getRealFitnessFunction() instanceof SingleObjectiveFitnessFunction) {
                        infotext = "Fitness: " + ((SingleObjectiveFitnessFunction)EdgeSelectionView.this.schedule.getRealFitnessFunction()).evaluate(individual, null);
                    }
                    this.graphics.drawString(infotext, this.insets.left, this.insets.top - 10);
                    boolean[] map = gesGenotype.getEdgeSelection();
                    if (EdgeSelectionView.this.displayUnselectedEdges) {
                        int i = 0;
                        while (i < map.length) {
                            if (!map[i]) {
                                edge = graph.edgeForSpeedupIndex(i);
                                node1 = edge.getStartNode();
                                node2 = edge.getEndNode();
                                this.drawLine(graph.getLayoutX(node1), 1.0f - graph.getLayoutY(node1), graph.getLayoutX(node2), 1.0f - graph.getLayoutY(node2), edge.getWeight(), this.esview.unselectedEdgeColor);
                            }
                            ++i;
                        }
                    }
                    int i = 0;
                    while (i < map.length) {
                        if (map[i]) {
                            edge = graph.edgeForSpeedupIndex(i);
                            node1 = edge.getStartNode();
                            node2 = edge.getEndNode();
                            this.drawLine(graph.getLayoutX(node1), 1.0f - graph.getLayoutY(node1), graph.getLayoutX(node2), 1.0f - graph.getLayoutY(node2), edge.getWeight(), EdgeSelectionView.this.selectedEdgeColor);
                        }
                        ++i;
                    }
                    int nodeCount = graph.getNumberOfNodes();
                    int i2 = 0;
                    while (i2 < nodeCount) {
                        this.drawPoint(graph.getLayoutX(i2), 1.0f - graph.getLayoutY(i2), new Integer(i2).toString().toCharArray());
                        ++i2;
                    }
                }
            }
        }

        private void drawLine(double x1, double y1, double x2, double y2, int weight, Color edgeColor) {
            this.graphics.setColor(edgeColor);
            this.graphics.drawLine(this.insets.left + (int)(x1 * (double)this.currentWidth), this.insets.top + (int)(y1 * (double)this.currentHeight), this.insets.left + (int)(x2 * (double)this.currentWidth), this.insets.top + (int)(y2 * (double)this.currentHeight));
            if (this.esview.displayEdgeWeights) {
                this.graphics.setColor(this.esview.edgeWeightColor);
                this.graphics.drawString(Integer.toString(weight), this.insets.left + (int)((0.55 * x2 + 0.45 * x1) * (double)this.currentWidth), this.insets.top + (int)((0.55 * y2 + 0.45 * y1) * (double)this.currentHeight));
            }
        }

        private void drawPoint(double x, double y, char[] c) {
            this.graphics.setColor(this.esview.nodeColor);
            this.graphics.fillOval(this.insets.left + (int)(x * (double)this.currentWidth) - 1, this.insets.top + (int)(y * (double)this.currentHeight) - 1, 2, 2);
            if (this.esview.displayNodeNumbers) {
                this.graphics.setColor(this.esview.nodeNumberColor);
                this.graphics.drawChars(c, 0, c.length, this.insets.left + (int)(x * (double)this.currentWidth) + 2, this.insets.top + (int)(y * (double)this.currentHeight) + 10);
            }
        }
    }
}

