/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import freak.core.control.EventController;
import freak.core.control.StaticEventSourceRemovedException;
import freak.core.event.EventListener;
import freak.core.event.EventSource;
import java.io.Serializable;
import java.lang.reflect.Method;

public class EventInfo
implements Serializable {
    private EventListener owner;
    private boolean isStatic;
    private boolean isRegistered = false;
    private String eventName;
    private Class eventType;
    private EventSource eventSource;

    public EventInfo(EventListener owner, String eventName, Class eventType, EventSource eventSource, boolean isStatic) {
        if (owner == null) {
            throw new NullPointerException("EventInfo: owner must not be null.");
        }
        if (eventType == null) {
            throw new NullPointerException("EventInfo: Not allowed to add an event of type null.");
        }
        if (eventSource != null && !EventController.getEventSourceClassFor(eventType).isAssignableFrom(eventSource.getClass())) {
            throw new ClassCastException("EventInfo: Object " + eventSource + " isn't a source for event " + eventType);
        }
        if (owner != null && !EventController.getEventListenerClassFor(eventType).isAssignableFrom(owner.getClass())) {
            throw new ClassCastException("EventInfo: Object " + eventSource + " isn't a listener for event " + eventType);
        }
        this.owner = owner;
        this.eventName = eventName;
        this.eventType = eventType;
        this.eventSource = eventSource;
        this.isStatic = isStatic;
        if (this.eventSource != null) {
            this.register();
        }
    }

    public EventListener getOwner() {
        return this.owner;
    }

    public String getEventName() {
        return this.eventName;
    }

    public EventSource getEventSource() {
        return this.eventSource;
    }

    public Class getEventType() {
        return this.eventType;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setEventSource(EventSource source) {
        if (!this.isStatic) {
            if (source != null) {
                this.replaceEventSource(source);
            } else {
                this.eventSource = source;
            }
        } else {
            throw new RuntimeException("trying to set the eventsource of static event " + this.getEventName() + " (" + this.getEventType() + ")");
        }
    }

    public void replaceEventSource(EventSource newSource) {
        if (this.isStatic && newSource == null) {
            throw new StaticEventSourceRemovedException("trying to replace the eventsource of static event " + this.getEventName() + " (" + this.getEventType() + ") with a null object.");
        }
        if (this.isRegistered) {
            this.unregister();
        }
        this.eventSource = newSource;
        this.register();
    }

    public void register() {
        if (!this.isRegistered && this.eventSource != null) {
            try {
                Method mthd = EventController.getAddListenerMethodFor(this);
                mthd.invoke((Object)this.eventSource, this.owner);
                this.isRegistered = true;
            }
            catch (Exception e) {
                System.out.println("error while registering " + this.owner + " for event " + this.eventType + " at source " + this.eventSource);
                e.printStackTrace();
            }
        }
    }

    public void unregister() {
        if (this.isRegistered && this.eventSource != null) {
            try {
                Method mthd = EventController.getRemoveListenerMethodFor(this);
                mthd.invoke((Object)this.eventSource, this.owner);
                this.isRegistered = false;
            }
            catch (Exception e) {
                System.out.println("error while unregistering " + this.owner + " from event " + this.eventType + " at source " + this.eventSource);
                e.printStackTrace();
            }
        }
    }
}

