/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.services;

import edu.ucsb.cs.jicos.foundation.Command;
import edu.ucsb.cs.jicos.foundation.CommandList;
import edu.ucsb.cs.jicos.foundation.CommandSynchronous;
import edu.ucsb.cs.jicos.foundation.Department;
import edu.ucsb.cs.jicos.foundation.Proxy;
import edu.ucsb.cs.jicos.foundation.RemoteExceptionHandler;
import edu.ucsb.cs.jicos.foundation.Service;
import edu.ucsb.cs.jicos.foundation.ServiceImpl;
import edu.ucsb.cs.jicos.foundation.ServiceName;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.HspAgent;
import edu.ucsb.cs.jicos.services.HspProxy;
import edu.ucsb.cs.jicos.services.JicosRemoteExceptionHandler;
import edu.ucsb.cs.jicos.services.Result;
import edu.ucsb.cs.jicos.services.SessionInfo;
import edu.ucsb.cs.jicos.services.Shared;
import edu.ucsb.cs.jicos.services.Task;
import edu.ucsb.cs.jicos.services.TaskInfo;
import edu.ucsb.cs.jicos.services.TaskServer;
import edu.ucsb.cs.jicos.services.TaskServerProxy;
import edu.ucsb.cs.jicos.services.commands.ExecuteTask;
import edu.ucsb.cs.jicos.services.commands.GetServiceName;
import edu.ucsb.cs.jicos.services.commands.GetTaskServer;
import edu.ucsb.cs.jicos.services.commands.ProcessResult;
import edu.ucsb.cs.jicos.services.commands.PutResult;
import edu.ucsb.cs.jicos.services.commands.RegisterHost;
import edu.ucsb.cs.jicos.services.commands.RequestTask;
import edu.ucsb.cs.jicos.services.commands.SetArg;
import edu.ucsb.cs.jicos.utilities.Qu;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;

public final class Host
extends ServiceImpl {
    private static final Class[][] command2DepartmentArray;
    private static final CommandSynchronous GET_SERVICE_NAME;
    private static final CommandSynchronous GET_TASKSERVER;
    private static final RemoteExceptionHandler REMOTE_EXCEPTION_HANDLER;
    private static final boolean prefetchOn = true;
    private static final boolean cacheOn = true;
    private Department computeDepartment = new Department(this, new Qu(), 1);
    private Department[] departments = new Department[]{ServiceImpl.ASAP_DEPARTMENT, this.computeDepartment};
    private final Command REQUEST_TASK = new RequestTask(this);
    private HspProxy hspProxy;
    private Service myTaskServer;
    private Proxy taskServerProxy;
    private boolean amInternalHost;
    private Department internalCommandDepartment;
    private SessionInfo sessionInfo;
    private long sessionId;
    private Environment environment;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$LoginClient;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$UpdateShared;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$ExecuteTask;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$Host;

    Host(Service service, String string, Service service2) throws RemoteException {
        super(command2DepartmentArray, string);
        int n;
        super.setService(this);
        super.setDepartments(this.departments);
        if (service2 == null) {
            ServiceName serviceName = null;
            serviceName = (ServiceName)service.executeCommand(this, GET_SERVICE_NAME);
            System.out.println("Host<" + string + ">.constructor: Hsp.serviceName: " + serviceName);
            this.hspProxy = new HspProxy(serviceName, this, REMOTE_EXCEPTION_HANDLER);
            serviceName = (ServiceName)this.hspProxy.execute(GET_TASKSERVER, REMOTE_EXCEPTION_HANDLER);
            System.out.println("Host.constructor: TaskServer.serviceName: " + serviceName);
            this.myTaskServer = serviceName.service();
            this.taskServerProxy = new TaskServerProxy(serviceName, this, REMOTE_EXCEPTION_HANDLER);
            n = Runtime.getRuntime().availableProcessors();
            this.computeDepartment.addProcessors(n - 1);
            RegisterHost registerHost = new RegisterHost(this.serviceName());
            this.sessionInfo = (SessionInfo)this.taskServerProxy.execute(registerHost, REMOTE_EXCEPTION_HANDLER);
            CommandList commandList = new CommandList();
            int n2 = 0;
            while (n2 < n) {
                commandList.add(this.REQUEST_TASK);
                ++n2;
            }
            this.taskServerProxy.execute(commandList);
        } else {
            this.myTaskServer = service2;
            this.hspProxy = ((TaskServer)service2).hspProxy();
            System.out.println("Host.constructor: internal Host serviceName: " + this.serviceName());
            this.taskServerProxy = new TaskServerProxy(((ServiceImpl)service2).serviceName(), this, REMOTE_EXCEPTION_HANDLER);
            this.amInternalHost = true;
            n = 1;
            this.internalCommandDepartment = ((TaskServer)service2).internalCommandDepartment();
            this.sessionInfo = ((TaskServer)service2).registerHost(this.serviceName(), true);
        }
        if (this.sessionInfo != null) {
            this.initSession();
        }
        super.register(service2);
        System.out.println("Host: Ready. Compute processors: " + n);
    }

    Department computeDepartment() {
        return this.computeDepartment;
    }

    public void exceptionHandler(Exception exception) {
        Result result = new Result(null, exception, 0L);
        PutResult putResult = new PutResult(null, result);
        this.hspProxy.execute(putResult);
    }

    public void executeTask(Task task) throws Exception {
        Serializable serializable;
        if (!$assertionsDisabled && task == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.sessionInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && task.getTaskId().getSessionId() != this.sessionId) {
            throw new AssertionError();
        }
        if (task.isAtomic(this.environment)) {
            this.taskServerProxy.execute(this.REQUEST_TASK);
        }
        long l = System.currentTimeMillis();
        Object object = null;
        try {
            object = task.execute(this.environment);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Host: executeTask: ComputeException \n" + exception.getMessage());
            Result result = new Result(task.getTaskId(), exception, 0L);
            PutResult putResult = new PutResult(task.getTaskId(), result);
            this.hspProxy.execute(putResult);
            this.taskServerProxy.execute(this.REQUEST_TASK);
            return;
        }
        long l2 = System.currentTimeMillis();
        int n = (int)(l2 - l);
        TaskInfo taskInfo = new TaskInfo(this, task, n);
        ExecuteTask executeTask = null;
        boolean bl = false;
        if (object instanceof Task) {
            task.initCompose((Task)object);
            taskInfo.set(task.getChildren());
            if (task.getChildren().size() > 0) {
                Task task2 = (Task)task.getChildren().get(0);
                task2.setCached(true);
                task2.setSpawningHost(this);
                task2.setTaskServer(this.myTaskServer);
                try {
                    serializable = new MarshalledObject<Task>(task2);
                    executeTask = new ExecuteTask((Task)((MarshalledObject)serializable).get());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Host: executeTask: [un]marshal error \n" + exception.getMessage());
                    Result result = new Result(task.getTaskId(), exception, 0L);
                    PutResult putResult = new PutResult(task.getTaskId(), result);
                    this.hspProxy.execute(putResult);
                    this.taskServerProxy.execute(this.REQUEST_TASK);
                    return;
                }
                bl = true;
            }
        } else {
            if (!$assertionsDisabled && task.getSuccessorTaskId() == null) {
                throw new AssertionError();
            }
            if (task.getTaskServer().equals(this.myTaskServer)) {
                taskInfo.set(task.getSuccessorTaskId(), task.getSuccessorIndex(), object);
            } else {
                long l3 = taskInfo.getCriticalPathTime();
                SetArg setArg = new SetArg(task.getSuccessorTaskId(), task.getSuccessorIndex(), object, l3);
                ServiceName serviceName = task.taskServerServiceName();
                Service service = serviceName.service();
                Proxy proxy = this.getProxy(service);
                if (proxy == null) {
                    proxy = new TaskServerProxy(serviceName, this, REMOTE_EXCEPTION_HANDLER);
                    this.addProxy(serviceName, proxy);
                }
                proxy.execute(setArg);
            }
        }
        ProcessResult processResult = new ProcessResult(taskInfo);
        if (this.amInternalHost) {
            this.internalCommandDepartment.addCommand(processResult);
            return;
        }
        serializable = new CommandList();
        ((CommandList)serializable).add(processResult);
        if (!task.isAtomic(this.environment) && !bl) {
            ((CommandList)serializable).add(this.REQUEST_TASK);
        }
        this.taskServerProxy.execute((Command)serializable);
        if (bl) {
            this.computeDepartment.addCommand(executeTask);
        }
    }

    Command getRequestTask() {
        return this.REQUEST_TASK;
    }

    Service getTaskServer() {
        return this.myTaskServer;
    }

    void initSession() {
        this.sessionId = this.sessionInfo.getSessionId();
        this.environment = this.sessionInfo.getEnvironment();
        this.environment.setHost(this);
    }

    public void loginClient(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo.copy();
        this.initSession();
    }

    RemoteExceptionHandler remoteExceptionHandler() {
        return REMOTE_EXCEPTION_HANDLER;
    }

    public void setShared(Shared shared) {
        if (!$assertionsDisabled && shared == null) {
            throw new AssertionError();
        }
        if (this.sessionInfo == null) {
            System.out.println("Host.setShared: No client. Ignoring.");
            return;
        }
        if (shared.isNewerThan(this.environment.getShared())) {
            this.environment.setShared(shared);
        }
        System.out.println("Host: updateShared: actual shared: " + shared.get());
    }

    public void shutdown() {
    }

    synchronized Proxy taskServerProxy() {
        return this.taskServerProxy;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Command line: <HSP-domain-name>");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[0];
        HspAgent hspAgent = new HspAgent(string);
        Service service = hspAgent.getHsp();
        new Host(service, string2, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$services$Host == null ? (class$edu$ucsb$cs$jicos$services$Host = Host.class$("edu.ucsb.cs.jicos.services.Host")) : class$edu$ucsb$cs$jicos$services$Host).desiredAssertionStatus();
        command2DepartmentArray = new Class[][]{{class$edu$ucsb$cs$jicos$services$commands$LoginClient == null ? (class$edu$ucsb$cs$jicos$services$commands$LoginClient = Host.class$("edu.ucsb.cs.jicos.services.commands.LoginClient")) : class$edu$ucsb$cs$jicos$services$commands$LoginClient, class$edu$ucsb$cs$jicos$services$commands$UpdateShared == null ? (class$edu$ucsb$cs$jicos$services$commands$UpdateShared = Host.class$("edu.ucsb.cs.jicos.services.commands.UpdateShared")) : class$edu$ucsb$cs$jicos$services$commands$UpdateShared}, {class$edu$ucsb$cs$jicos$services$commands$ExecuteTask == null ? (class$edu$ucsb$cs$jicos$services$commands$ExecuteTask = Host.class$("edu.ucsb.cs.jicos.services.commands.ExecuteTask")) : class$edu$ucsb$cs$jicos$services$commands$ExecuteTask}};
        GET_SERVICE_NAME = new GetServiceName();
        GET_TASKSERVER = new GetTaskServer();
        REMOTE_EXCEPTION_HANDLER = new JicosRemoteExceptionHandler();
    }
}

