/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.utilities.graph;

import edu.ucsb.cs.jicos.applications.utilities.graph.GraphEuclidean;

public final class WeightedMatch {
    public static final boolean MINIMIZE = true;
    public static final boolean MAXIMIZE = false;
    private static final boolean DEBUG = false;
    private static final int UNMATCHED = 0;
    private int[][] costs;
    private int V;
    private int E;
    private int dummyVertex;
    private int dummyEdge;
    private int[] a;
    private int[] end;
    private int[] mate;
    private int[] weight;
    private int[] base;
    private int[] lastEdge = new int[3];
    private int[] lastVertex;
    private int[] link;
    private int[] nextDelta;
    private int[] nextEdge;
    private int[] nextPair;
    private int[] nextVertex;
    private int[] y;
    private int delta;
    private int lastDelta;
    private int newBase;
    private int nextBase;
    private int oldBase;
    private int stopScan;
    private int pairPoint;
    private int neighbor;
    private int newLast;
    private int nextPoint;
    private int firstMate;
    private int newMate;
    private int oldFirst;
    private int oldMate;
    private int secondMate;
    private int f;
    private int nxtEdge;
    private int nextE;
    private int nextU;
    private int e;
    private int v;
    private int i;

    public WeightedMatch(int[][] nArray) {
        this.costs = nArray;
    }

    public int[] weightedMatch(boolean bl) {
        boolean bl2 = true;
        this.input(this.costs);
        this.initialize(this.costs, bl);
        while (true) {
            int n;
            this.delta = 0;
            this.v = 1;
            while (this.v <= this.V) {
                if (this.mate[this.v] == this.dummyEdge) {
                    this.pointer(this.dummyVertex, this.v, this.dummyEdge);
                }
                ++this.v;
            }
            while (true) {
                this.i = 1;
                n = 2;
                while (n <= this.V) {
                    if (this.nextDelta[this.i] > this.nextDelta[n]) {
                        this.i = n;
                    }
                    ++n;
                }
                this.delta = this.nextDelta[this.i];
                if (this.delta == this.lastDelta) {
                    this.setBounds();
                    this.unpairAll();
                    this.i = 1;
                    while (this.i <= this.V) {
                        this.mate[this.i] = this.end[this.mate[this.i]];
                        if (this.mate[this.i] == this.dummyVertex) {
                            this.mate[this.i] = 0;
                        }
                        ++this.i;
                    }
                    return this.mate;
                }
                this.v = this.base[this.i];
                if (this.link[this.v] >= 0) {
                    if (!this.pair()) continue;
                    break;
                }
                int n2 = this.bmate(this.v);
                if (this.link[n2] < 0) {
                    this.pointer(this.v, n2, this.oppEdge(this.nextEdge[this.i]));
                    continue;
                }
                this.unpair(this.v, n2);
            }
            this.lastDelta -= this.delta;
            this.setBounds();
            n = this.oppEdge(this.e);
            this.rematch(this.bend(this.e), n);
            this.rematch(this.bend(n), this.e);
        }
    }

    private int bend(int n) {
        return this.base[this.end[n]];
    }

    private int blink(int n) {
        return this.base[this.end[this.link[n]]];
    }

    private int bmate(int n) {
        return this.base[this.end[this.mate[n]]];
    }

    private int oppEdge(int n) {
        return (n - this.V) % 2 == 0 ? n - 1 : n + 1;
    }

    private int slack(int n) {
        return this.y[this.end[n]] + this.y[this.end[this.oppEdge(n)]] - this.weight[n];
    }

    private void initialize(int[][] nArray, boolean bl) {
        int n;
        this.setUp(nArray);
        this.dummyVertex = this.V + 1;
        this.dummyEdge = this.V + 2 * this.E + 1;
        this.end[this.dummyEdge] = this.dummyVertex;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < this.V) {
            int n5 = n4 + 1;
            while (n5 < this.V) {
                n = 2 * nArray[n4][n5];
                if (n > n2) {
                    n2 = n;
                }
                if (n < n3) {
                    n3 = n;
                }
                ++n5;
            }
            ++n4;
        }
        if (bl) {
            if (this.V % 2 != 0) {
                throw new IllegalArgumentException("|V| must be even for a minimum cost maximum matching.");
            }
            n2 += 2;
            n = this.V + 1;
            while (n <= this.V + 2 * this.E) {
                this.weight[n] = n2 - this.weight[n];
                ++n;
            }
            n2 -= n3;
        }
        this.lastDelta = n2 / 2;
        n = this.V + 2;
        this.mate = new int[n];
        this.link = new int[n];
        this.base = new int[n];
        this.nextVertex = new int[n];
        this.lastVertex = new int[n];
        this.y = new int[n];
        this.nextDelta = new int[n];
        this.nextEdge = new int[n];
        n = this.V + 2 * this.E + 2;
        this.nextPair = new int[n];
        this.i = 1;
        while (this.i <= this.V + 1) {
            this.mate[this.i] = this.nextEdge[this.i] = this.dummyEdge;
            this.nextVertex[this.i] = 0;
            this.link[this.i] = -this.dummyEdge;
            this.base[this.i] = this.lastVertex[this.i] = this.i;
            this.y[this.i] = this.nextDelta[this.i] = this.lastDelta;
            ++this.i;
        }
    }

    private void input(int[][] nArray) {
        this.V = nArray.length;
        this.E = this.V * (this.V - 1) / 2;
        int n = this.V + 2 * this.E + 2;
        this.a = new int[n];
        this.end = new int[n];
        this.weight = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.weight[n2] = 0;
            this.end[n2] = 0;
            this.a[n2] = 0;
            ++n2;
        }
    }

    private void insertPair() {
        int n = this.slack(this.e) / 2;
        this.nextPoint = this.nextPair[this.pairPoint];
        while (this.end[this.nextPoint] < this.neighbor) {
            this.pairPoint = this.nextPoint;
            this.nextPoint = this.nextPair[this.nextPoint];
        }
        if (this.end[this.nextPoint] == this.neighbor) {
            if (n >= this.slack(this.nextPoint) / 2) {
                return;
            }
            this.nextPoint = this.nextPair[this.nextPoint];
        }
        this.nextPair[this.pairPoint] = this.e;
        this.pairPoint = this.e;
        this.nextPair[this.e] = this.nextPoint;
        if (this.nextDelta[this.newBase] > n) {
            this.nextDelta[this.newBase] = n;
        }
    }

    private void linkPath(int n) {
        this.v = this.bend(n);
        while (this.v != this.newBase) {
            int n2 = this.bmate(this.v);
            this.link[n2] = this.oppEdge(n);
            this.nextVertex[this.newLast] = this.v;
            this.nextVertex[this.lastVertex[this.v]] = n2;
            this.newLast = this.lastVertex[n2];
            this.i = this.v;
            do {
                this.base[this.i] = this.newBase;
                this.i = this.nextVertex[this.i];
            } while (this.i != this.dummyVertex);
            n = this.link[this.v];
            this.v = this.bend(n);
        }
    }

    private void mergePairs(int n) {
        this.nextDelta[n] = this.lastDelta;
        this.pairPoint = this.dummyEdge;
        this.f = this.nextEdge[n];
        while (this.f != this.dummyEdge) {
            this.e = this.f;
            this.neighbor = this.end[this.e];
            this.f = this.nextPair[this.f];
            if (this.base[this.neighbor] == this.newBase) continue;
            this.insertPair();
        }
    }

    private boolean pair() {
        this.e = this.nextEdge[this.v];
        while (this.slack(this.e) != 2 * this.delta) {
            this.e = this.nextPair[this.e];
        }
        int n = this.bend(this.e);
        this.link[this.bmate((int)n)] = -this.e;
        int n2 = this.bmate(this.v);
        while (this.link[n2] != -this.e) {
            this.link[n2] = -this.e;
            if (this.mate[n] != this.dummyEdge) {
                int n3 = this.v;
                this.v = n;
                n = n3;
            }
            this.v = this.blink(this.v);
            n2 = this.bmate(this.v);
        }
        if (n2 == this.dummyVertex && this.v != n) {
            return true;
        }
        this.newLast = this.newBase = this.v;
        this.oldFirst = this.nextVertex[this.v];
        this.linkPath(this.e);
        this.linkPath(this.oppEdge(this.e));
        this.nextVertex[this.newLast] = this.oldFirst;
        if (this.lastVertex[this.newBase] == this.newBase) {
            this.lastVertex[this.newBase] = this.newLast;
        }
        this.nextPair[this.dummyEdge] = this.dummyEdge;
        this.mergePairs(this.newBase);
        this.i = this.nextVertex[this.newBase];
        do {
            this.mergePairs(this.i);
            this.i = this.nextVertex[this.lastVertex[this.i]];
            this.scan(this.i, 2 * this.delta - this.slack(this.mate[this.i]));
            this.i = this.nextVertex[this.lastVertex[this.i]];
        } while (this.i != this.oldFirst);
        return false;
    }

    private void pointer(int n, int n2, int n3) {
        int n4;
        int n5;
        this.link[n] = -this.dummyEdge;
        int n6 = this.dummyVertex;
        this.nextVertex[this.lastVertex[n2]] = n6;
        this.nextVertex[this.lastVertex[n]] = n6;
        if (this.lastVertex[n] != n) {
            n5 = this.mate[this.nextVertex[n]];
            n4 = -this.slack(n5) / 2;
        } else {
            n4 = this.lastDelta;
        }
        n5 = n;
        while (n5 != this.dummyVertex) {
            int n7 = n5;
            this.y[n7] = this.y[n7] + n4;
            int n8 = n5;
            this.nextDelta[n8] = this.nextDelta[n8] + n4;
            n5 = this.nextVertex[n5];
        }
        if (this.link[n2] < 0) {
            this.link[n2] = n3;
            this.nextPair[this.dummyEdge] = this.dummyEdge;
            this.scan(n2, this.delta);
        } else {
            this.link[n2] = n3;
        }
    }

    private void rematch(int n, int n2) {
        this.mate[n] = n2;
        this.nextE = -this.link[n];
        while (this.nextE != this.dummyEdge) {
            n2 = this.nextE;
            this.f = this.oppEdge(n2);
            n = this.bend(n2);
            this.secondMate = this.bend(this.f);
            this.nextE = -this.link[n];
            this.link[n] = -this.mate[this.secondMate];
            this.link[this.secondMate] = -this.mate[n];
            this.mate[n] = this.f;
            this.mate[this.secondMate] = n2;
        }
    }

    private void scan(int n, int n2) {
        this.newBase = this.base[n];
        this.stopScan = this.nextVertex[this.lastVertex[n]];
        while (n != this.stopScan) {
            int n3 = n;
            this.y[n3] = this.y[n3] + n2;
            this.nextDelta[n] = this.lastDelta;
            this.pairPoint = this.dummyEdge;
            this.e = this.a[n];
            while (this.e != 0) {
                this.neighbor = this.end[this.e];
                int n4 = this.base[this.neighbor];
                if (this.link[n4] < 0) {
                    int n5;
                    if ((this.link[this.bmate(n4)] < 0 || this.lastVertex[n4] != n4) && this.nextDelta[this.neighbor] > (n5 = this.slack(this.e))) {
                        this.nextDelta[this.neighbor] = n5;
                        this.nextEdge[this.neighbor] = this.e;
                    }
                } else if (n4 != this.newBase) {
                    this.insertPair();
                }
                this.e = this.a[this.e];
            }
            n = this.nextVertex[n];
        }
        this.nextEdge[this.newBase] = this.nextPair[this.dummyEdge];
    }

    private void setBounds() {
        this.v = 1;
        while (this.v <= this.V) {
            if (this.link[this.v] < 0 || this.base[this.v] != this.v) {
                this.nextDelta[this.v] = this.lastDelta;
            } else {
                this.link[this.v] = -this.link[this.v];
                this.i = this.v;
                while (this.i != this.dummyVertex) {
                    int n = this.i;
                    this.y[n] = this.y[n] - this.delta;
                    this.i = this.nextVertex[this.i];
                }
                this.f = this.mate[this.v];
                if (this.f != this.dummyEdge) {
                    this.i = this.bend(this.f);
                    int n = this.slack(this.f);
                    while (this.i != this.dummyVertex) {
                        int n2 = this.i;
                        this.y[n2] = this.y[n2] - n;
                        this.i = this.nextVertex[this.i];
                    }
                }
                this.nextDelta[this.v] = this.lastDelta;
            }
            ++this.v;
        }
    }

    private void setUp(int[][] nArray) {
        int n = this.V + 2;
        int n2 = this.V;
        while (n2 >= 1) {
            int n3 = n2 - 1;
            while (n3 >= 1) {
                int n4;
                this.weight[n - 1] = this.weight[n] = (n4 = 2 * nArray[n2 - 1][n3 - 1]);
                this.end[n - 1] = n2;
                this.end[n] = n3;
                this.a[n] = this.a[n2];
                this.a[n2] = n;
                this.a[n - 1] = this.a[n3];
                this.a[n3] = n - 1;
                n += 2;
                --n3;
            }
            --n2;
        }
    }

    private void unlink(int n) {
        this.i = this.newBase = this.nextVertex[n];
        this.nextBase = this.nextVertex[this.lastVertex[this.newBase]];
        this.e = this.link[this.nextBase];
        int n2 = 1;
        while (n2 <= 2) {
            do {
                this.nxtEdge = this.oppEdge(this.link[this.newBase]);
                int n3 = 1;
                while (n3 <= 2) {
                    this.link[this.newBase] = -this.link[this.newBase];
                    do {
                        this.base[this.i] = this.newBase;
                        this.i = this.nextVertex[this.i];
                    } while (this.i != this.nextBase);
                    this.newBase = this.nextBase;
                    this.nextBase = this.nextVertex[this.lastVertex[this.newBase]];
                    ++n3;
                }
            } while (this.link[this.nextBase] == this.nxtEdge);
            if (n2 != 1) break;
            this.lastEdge[1] = this.nxtEdge;
            this.nxtEdge = this.oppEdge(this.e);
            if (this.link[this.nextBase] != this.nxtEdge) break;
            ++n2;
        }
        this.lastEdge[2] = this.nxtEdge;
        if (this.base[this.lastVertex[n]] == n) {
            this.nextVertex[n] = this.newBase;
        } else {
            this.nextVertex[n] = this.dummyVertex;
            this.lastVertex[n] = n;
        }
    }

    private void unpair(int n, int n2) {
        int n3;
        int n4;
        this.unlink(n);
        int n5 = this.bmate(n2);
        if (n5 != n) {
            this.link[n] = -this.dummyEdge;
            this.rematch(n5, this.mate[n]);
            int n6 = this.link[this.secondMate] = this.f == this.lastEdge[1] ? -this.lastEdge[2] : -this.lastEdge[1];
        }
        if ((n4 = this.bend(this.oppEdge(n3 = this.link[n2]))) == n5) {
            this.pointer(n5, n2, n3);
            return;
        }
        this.link[this.bmate((int)n4)] = -n3;
        do {
            n3 = -this.link[n4];
            this.v = this.bmate(n4);
            this.pointer(n4, this.v, -this.link[this.v]);
        } while ((n4 = this.bend(n3)) != n5);
        n3 = this.oppEdge(n3);
        this.pointer(n5, n2, n3);
    }

    private void unpairAll() {
        this.v = 1;
        while (this.v <= this.V) {
            if (this.base[this.v] == this.v && this.lastVertex[this.v] != this.v) {
                this.nextU = this.v;
                this.nextVertex[this.lastVertex[this.nextU]] = this.dummyVertex;
                do {
                    int n = this.nextU;
                    this.nextU = this.nextVertex[this.nextU];
                    this.unlink(n);
                    if (this.lastVertex[n] != n) {
                        this.f = this.lastEdge[2] == this.oppEdge(this.e) ? this.lastEdge[1] : this.lastEdge[2];
                        this.nextVertex[this.lastVertex[this.bend((int)this.f)]] = n;
                    }
                    this.newBase = this.bmate(this.bmate(n));
                    if (this.newBase != this.dummyVertex && this.newBase != n) {
                        this.link[n] = -this.dummyEdge;
                        this.rematch(this.newBase, this.mate[n]);
                    }
                    while (this.lastVertex[this.nextU] == this.nextU && this.nextU != this.dummyVertex) {
                        this.nextU = this.nextVertex[this.nextU];
                    }
                } while (this.lastVertex[this.nextU] != this.nextU || this.nextU != this.dummyVertex);
            }
            ++this.v;
        }
    }

    public int[] getMatched(int[] nArray) {
        int[] nArray2 = new int[this.costs.length];
        System.arraycopy(nArray, 1, nArray2, 0, nArray2.length);
        int n = 0;
        while (n < nArray2.length) {
            int n2 = n++;
            nArray2[n2] = nArray2[n2] - 1;
        }
        return nArray2;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        GraphEuclidean graphEuclidean = new GraphEuclidean(n, n, 100);
        int[][] nArray = graphEuclidean.getCosts();
        long l = System.currentTimeMillis();
        WeightedMatch weightedMatch = new WeightedMatch(nArray);
        int[] nArray2 = weightedMatch.weightedMatch(true);
        long l2 = System.currentTimeMillis();
        System.out.println("Elapsed time (in milliseconds) for " + n + " node graph is " + (l2 - l));
        int n2 = 1;
        while (n2 <= nArray.length) {
            System.out.println(" " + n2 + " matches " + nArray2[n2]);
            ++n2;
        }
        System.out.println("main: Done.");
    }
}

