/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.bitstring;

import freak.core.graph.OperatorGraph;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.SearchSpace;
import freak.core.util.FreakMath;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class FixedCardinalityCrossover
extends MultiPairwiseCrossover {
    public FixedCardinalityCrossover(OperatorGraph graph) {
        super(graph);
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        SearchSpace searchspace = this.graph.getSchedule().getGenotypeSearchSpace();
        int dimension = ((HasDimension)((Object)searchspace)).getDimension();
        BitSet bs1 = ((BitStringGenotype)ind1.getGenotype()).getBitSet();
        BitSet bs2 = ((BitStringGenotype)ind2.getGenotype()).getBitSet();
        BitSet bsOut = (BitSet)bs1.clone();
        int cardinality = bs1.cardinality();
        bsOut.or(bs2);
        int orCardinality = bsOut.cardinality();
        if (cardinality < orCardinality) {
            int[] indices = new int[orCardinality];
            int j = 0;
            int i = bsOut.nextSetBit(0);
            while (i >= 0) {
                indices[j++] = i;
                i = bsOut.nextSetBit(i + 1);
            }
            int[] chosenIndices = FreakMath.getKofN(this.graph.getSchedule(), cardinality, orCardinality);
            bsOut.clear();
            int i2 = 0;
            while (i2 < chosenIndices.length) {
                bsOut.set(indices[chosenIndices[i2]]);
                ++i2;
            }
        }
        return new Individual(this.graph.getSchedule(), new BitStringGenotype(bsOut, dimension), new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        return "This crossover preserves the number of set bits by choosing set bits from the individuals uniformly at random.";
    }

    public String getName() {
        return "Fixed Cardinality Crossover";
    }
}

