/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer.isingmodelcliques;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.IncompatibleModulePropertyException;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.module.fitness.generalstring.IsingModelCliques;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class CliquesPotentialFunction
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public CliquesPotentialFunction(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        if (!(schedule.getRealFitnessFunction() instanceof IsingModelCliques)) {
            throw new UnsupportedEnvironmentException("This module works on Ising Model Cliques only.");
        }
        if (((IsingModelCliques)schedule.getRealFitnessFunction()).getPropertyNumberOfCliques() != 2) {
            throw new IncompatibleModulePropertyException(schedule.getRealFitnessFunction(), "Number of Cliques", "This observer only works on two cliques.");
        }
        if (((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getNumChars() != 2) {
            throw new IncompatibleModulePropertyException(schedule.getGenotypeSearchSpace(), "Number of Chars", "This observer only works on cliques colored with two colors.");
        }
    }

    public String getName() {
        return "Cliques Potential Function";
    }

    public String getDescription() {
        return "Computes the following potential function on two cliques: phi(x) := (number of 0-colored nodes in x - n/2)";
    }

    public Class getOutputDataType() {
        return int[].class;
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        int[] result = new int[individuals.length];
        int i = 0;
        while (i < individuals.length) {
            result[i] = this.computePotentialFunction(individuals[i]);
            ++i;
        }
        this.updateViews(result);
    }

    public int computePotentialFunction(Individual individual) {
        int result = 0;
        int[] genotype = ((GeneralStringGenotype)individual.getGenotype()).getIntArray();
        IsingModelCliques fitness = (IsingModelCliques)this.getSchedule().getRealFitnessFunction();
        IsingModelCliques.Clique[] cliques = fitness.getCliques();
        if (cliques.length == 2 && ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getNumChars() == 2) {
            int j = 0;
            while (j < cliques.length) {
                int i = 0;
                while (i < cliques[j].getSize()) {
                    if (genotype[cliques[j].getStart() + i] == 0) {
                        ++result;
                    }
                    ++i;
                }
                ++j;
            }
            result -= genotype.length / 2;
        }
        return result;
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

