/*
 * Decompiled with CFR 0.152.
 */
package freak.core.observer;

import freak.core.control.Schedule;
import freak.core.modulesupport.AbstractModule;
import freak.core.observer.Observer;
import freak.core.observer.ObserverViewMismatchException;
import freak.core.view.View;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractObserver
extends AbstractModule
implements Observer {
    private int measure = 0;
    private ArrayList viewList = new ArrayList();

    public AbstractObserver(Schedule schedule) {
        super(schedule);
    }

    public void addView(View view) throws ObserverViewMismatchException {
        boolean matches = false;
        Class[] types = view.getInputDataTypes();
        int i = 0;
        while (i < types.length) {
            matches |= types[i].isAssignableFrom(this.getOutputDataType());
            ++i;
        }
        if (!matches) {
            throw new ObserverViewMismatchException("View does not match the observer.");
        }
        this.viewList.add(view);
        view.setObserver(this);
    }

    public void removeView(View view) {
        this.viewList.remove(view);
        view.setObserver(null);
    }

    public List getViews() {
        return this.viewList;
    }

    public void updateViews(Object o) {
        Iterator iter = this.getViews().iterator();
        while (iter.hasNext()) {
            ((View)iter.next()).update(o);
        }
    }

    public int getMeasure() {
        return this.measure;
    }

    public void setMeasure(int measure) {
        this.measure = measure;
    }
}

