% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_model.v16.R
\name{log_lklh}
\alias{log_lklh}
\title{The likelihood function}
\usage{
log_lklh(
  param,
  params_limits,
  restrictions = NULL,
  restriction.starts = NULL,
  ranges = NULL,
  rt_func = 1,
  silence.errors = FALSE,
  fit.t.pred,
  lt,
  cases,
  scenario = NULL,
  H.E,
  H.W,
  adj.period,
  population,
  rho,
  serial_mean,
  serial_var,
  window_size
)
}
\arguments{
\item{param}{Includes the following sets of parameters in a vector, in this order:
\itemize{
  \item a1,a2,a3,a4 - Parameters for curve c() specified by \code{rt_func}.
  \item nu - Loss of Immunity rate.
  \item v2,v3,v4,v5 - Transmissibility of variants in waves 2+, as relative multiplication factors compared to transmissibility in wave 1.
  \item psi1,psi2,psi3,psi4 - Psi parameters for severity levels 1,2,3 and 4.
  \item u,v - Variance parameters. Only u is currently in use.
  \item beta0,beta.R,beta.E,beta.W - When restrictions = NULL. Currently unsupported.
}}

\item{params_limits}{Boundaries/limits of the ini_params.}

\item{restrictions}{A numeric integer vector giving the severity of restrictions.
Zero means no restriction, and higher numbers means greater severity/disruption.
The ordered unique values should be consecutive integers starting from zero.
Each number (other than 0) adds a new parameter to the fit. restrictions = NULL
causes the function to use mobility data instead of the psi values (currently unsupported).}

\item{restriction.starts}{A vector of same length as restrictions, of times when restrictions
came into effect. Note: the first index time should be 1.}

\item{ranges}{An vector of time ranges for the different waves.
The wave ranges should be contiguous, with at least one unit of time
between consecutive waves.}

\item{rt_func}{The parametric form of function c(). Options are listed under function c_helper.}

\item{silence.errors}{Ignores (skips) NA or NaN values when summing up likelihood contributions over time.}

\item{fit.t.pred}{Time of prediction.}

\item{lt}{Length of cases.}

\item{cases}{A vector containing cases for each time-point.}

\item{scenario}{A character string describing options to deal with restrictions. Currently unsupported.}

\item{H.E}{Mobility metrics for category Retail & Entertainment. Currently unsupported.}

\item{H.W}{Mobility metrics for category Workplaces. Currently unsupported.}

\item{adj.period}{Delays in society adjusting.}

\item{population}{total population size.}

\item{rho}{Under-reporting fraction.}

\item{serial_mean}{Mean of the serial interval on the log scale.}

\item{serial_var}{Variance of the serial interval on the log scale.}

\item{window_size}{The maximum value for the serial interval.}
}
\value{
The negative log likelihood value of the data.
}
\description{
The negative log likelihood function of the model.
}
\details{
The predicted curve is computed based on parameters supplied, by first calling the prediction
function \code{pred.curve}. The probability model used to compute the likelihood assumes that observed
infection at time \eqn{t} are \eqn{\sim N(mean = I_t, sd = \sqrt{u*I_t})}, where \eqn{I_t} are predicted infections, and sums the
log-likelihood contributions for each time \eqn{t} during waves, and up to \code{fit.t.pred}.
}
