/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.Distribution;
import umontreal.iro.lecuyer.rng.RandomStream;

public class RandomVariateGen {
    protected RandomStream stream;
    protected Distribution dist;

    protected RandomVariateGen() {
    }

    public RandomVariateGen(RandomStream randomStream, Distribution distribution) {
        if (randomStream == null || distribution == null) {
            throw new NullPointerException();
        }
        this.stream = randomStream;
        this.dist = distribution;
    }

    public double nextDouble() {
        return this.dist.inverseF(this.stream.nextDouble());
    }

    public void nextArrayOfDouble(double[] dArray, int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be positive.");
        }
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.nextDouble();
        }
    }

    public RandomStream getStream() {
        return this.stream;
    }

    public void setStream(RandomStream randomStream) {
        this.stream = randomStream;
    }

    public Distribution getDistribution() {
        return this.dist;
    }
}

