/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import umontreal.iro.lecuyer.rng.RandomStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomPermutation {
    private static final int SHUFFLE_THRESHOLD = 5;

    public static void shuffle(List<?> list, RandomStream randomStream) {
        int n = list.size();
        if (n < 5 || list instanceof RandomAccess) {
            for (int i = n; i > 1; --i) {
                Collections.swap(list, i - 1, randomStream.nextInt(0, i - 1));
            }
        } else {
            Object[] objectArray = list.toArray();
            RandomPermutation.shuffle(objectArray, randomStream);
            ListIterator<?> listIterator = list.listIterator();
            for (Object object : objectArray) {
                listIterator.next();
                listIterator.set(object);
            }
        }
    }

    public static void shuffle(Object[] objectArray, RandomStream randomStream) {
        int n = objectArray.length;
        for (int i = n - 1; i > 0; --i) {
            int n2 = randomStream.nextInt(0, i);
            Object object = objectArray[i];
            objectArray[i] = objectArray[n2];
            objectArray[n2] = object;
        }
    }

    public static void shuffle(byte[] byArray, RandomStream randomStream) {
        int n = byArray.length;
        for (int i = n - 1; i > 0; --i) {
            int n2 = randomStream.nextInt(0, i);
            byte by = byArray[i];
            byArray[i] = byArray[n2];
            byArray[n2] = by;
        }
    }

    public static void shuffle(short[] sArray, RandomStream randomStream) {
        int n = sArray.length;
        for (int i = n - 1; i > 0; --i) {
            int n2 = randomStream.nextInt(0, i);
            short s = sArray[i];
            sArray[i] = sArray[n2];
            sArray[n2] = s;
        }
    }

    public static void shuffle(int[] nArray, RandomStream randomStream) {
        int n = nArray.length;
        for (int i = n - 1; i > 0; --i) {
            int n2 = randomStream.nextInt(0, i);
            int n3 = nArray[i];
            nArray[i] = nArray[n2];
            nArray[n2] = n3;
        }
    }

    public static void shuffle(long[] lArray, RandomStream randomStream) {
        int n = lArray.length;
        for (int i = n - 1; i > 0; --i) {
            int n2 = randomStream.nextInt(0, i);
            long l = lArray[i];
            lArray[i] = lArray[n2];
            lArray[n2] = l;
        }
    }

    public static void shuffle(char[] cArray, RandomStream randomStream) {
        int n = cArray.length;
        for (int i = n - 1; i > 0; --i) {
            int n2 = randomStream.nextInt(0, i);
            char c = cArray[i];
            cArray[i] = cArray[n2];
            cArray[n2] = c;
        }
    }

    public static void shuffle(boolean[] blArray, RandomStream randomStream) {
        int n = blArray.length;
        for (int i = n - 1; i > 0; --i) {
            int n2 = randomStream.nextInt(0, i);
            boolean bl = blArray[i];
            blArray[i] = blArray[n2];
            blArray[n2] = bl;
        }
    }

    public static void shuffle(float[] fArray, RandomStream randomStream) {
        int n = fArray.length;
        for (int i = n - 1; i > 0; --i) {
            int n2 = randomStream.nextInt(0, i);
            float f = fArray[i];
            fArray[i] = fArray[n2];
            fArray[n2] = f;
        }
    }

    public static void shuffle(double[] dArray, RandomStream randomStream) {
        int n = dArray.length;
        for (int i = n - 1; i > 0; --i) {
            int n2 = randomStream.nextInt(0, i);
            double d = dArray[i];
            dArray[i] = dArray[n2];
            dArray[n2] = d;
        }
    }
}

