% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLmix.R
\name{TLmix}
\alias{TLmix}
\title{NPMLE for Student t location mixtures}
\usage{
TLmix(x, v = 300, u = 300, df = 1, hist = FALSE, weights = NULL, ...)
}
\arguments{
\item{x}{Data: Sample Observations}

\item{v}{bin boundaries defaults to equal spacing of length v}

\item{u}{bin boundaries for histogram binning: defaults to equal spacing}

\item{df}{Number of degrees of freedom of Student base density}

\item{hist}{If TRUE then aggregate x to histogram weights}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{optional parameters passed to KWDual to control optimization}
}
\value{
An object of class density with components: 
	\item{x}{midpoints of evaluation on the domain of the mixing density} 
	\item{y}{estimated function values at the points x of the mixing density} 
	\item{logLik}{Log likelihood value at the proposed solution} 
	\item{dy}{Bayes rule estimates of location at x} 
	\item{status}{Mosek exit code}
}
\description{
Kiefer Wolfowitz NPMLE for Student t location mixtures
}
\details{
Kiefer Wolfowitz MLE density estimation as proposed by Jiang and Zhang for
a Student t compound decision problem.  The histogram option is intended
for large problems, say n > 1000, where reducing the sample size dimension
is desirable. By default the grid for the binning is equally spaced on the
support of the data. Equal spaced binning is problematic for Cauchy data.
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}.  27, (1956), 887-906.

Jiang, Wenhua and Cun-Hui Zhang General maximum likelihood empirical Bayes
estimation of normal means \emph{Ann. Statist.}, 37, (2009), 1647-1684.
}
\seealso{
GLmix for Gaussian version
}
\author{
Roger Koenker
}
\keyword{nonparametric}
