% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RD_opt.R
\name{RDTEfficiencyBound}
\alias{RDTEfficiencyBound}
\title{Finite-sample efficiency bounds for minimax CIs}
\usage{
RDTEfficiencyBound(object, opt.criterion = "FLCI", beta = 0.5)
}
\arguments{
\item{object}{An object of class \code{"RDResults"}, typically a result of a
call to \code{\link{RDHonest}}.}

\item{opt.criterion}{Either \code{"FLCI"} for computing efficiency of
two-sided CIs, or else \code{"OCI"} for minimax one-sided CIs.}

\item{beta}{Determines quantile of excess length for evaluating minimax
efficiency of one-sided CIs. Ignored if \code{opt.criterion=="FLCI"}.}
}
\value{
Efficiency bound, a numeric vector of length one.
}
\description{
Compute efficiency of minimax one-sided CIs at constant functions, or
efficiency of two-sided fixed-length CIs at constant functions under
second-order Taylor smoothness class.
}
\examples{
r <- RDHonest(voteshare ~ margin, data=lee08,
              subset=abs(margin)<10, M=0.1, h=2)
RDTEfficiencyBound(r, opt.criterion="OCI")
}
\references{
{

\cite{Timothy B. Armstrong and Michal Kolesár. Optimal inference in a class
of regression models. Econometrica, 86(2):655–683, March 2018.
\doi{10.3982/ECTA14434}}

}
}
