% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance_regression.R
\name{balance_regression}
\alias{balance_regression}
\title{balance_regression() Runs a LPM of treatment status against all covariates (treatment~X'B).}
\usage{
balance_regression(data, treatment)
}
\arguments{
\item{data}{A data.frame, tibble or data.table}

\item{treatment}{a string with treatment status column}
}
\value{
A list: "regression_tables" = regression output of treatment~X'B, "F_test" = table with the F tests of each regression
}
\description{
balance_regression() Runs a LPM of treatment status against all covariates (treatment~X'B).
}
\details{
This functions runs a Linear Probability model of each treatment group & control on all the 
columns in data. For instance, if treatment column has values of (0,1,2), balance_regression will run two 
models: 1) LPM(treatment(0,1)~X'b) and 2) LPM(treatment(0,2)~X'b). The value are the regression tables and 
details of the F_test of these models.
}
\examples{
data <-data.frame(x = c(1:5), treatment = c(0,1,0,1,0))
balance_regression(data, "treatment")
}
