% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{chemical_shift_hist_res}
\alias{chemical_shift_hist_res}
\title{Plots chemical shift distribution of all atoms of a given amino acid}
\usage{
chemical_shift_hist_res(
  res = "*",
  type = "count",
  cutoff = 8,
  interactive = TRUE
)
}
\arguments{
\item{res}{residue name in NMR-STAR atom nomenclature ; Example: ALA,GLY}

\item{type}{count ; other than count will assume density plot}

\item{cutoff}{values not with in the cutoff time standard deviation from both sides ofthe mean will be excluded from the plot;default value 8}

\item{interactive}{TRUE/FALSE default TRUE}
}
\value{
R plot object
}
\description{
Plots the histogram (or) density of  chemical shift distribution of  all atoms of a given amino acid (or) nucleic acid from BMRB database.
}
\examples{
#plt<-chemical_shift_hist_res('ALA')
#plots the histogram of all atoms of ALA
#plt<-chemical_shift_hist('GLY',type='density')
#plots the density plot
}
\seealso{
\code{\link{fetch_res_chemical_shifts}},\code{\link{filter_residue}} and \code{\link{chem_shift_corr}} and \code{\link{atom_chem_shift_corr}}
}
