% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{chemical_shift_hist}
\alias{chemical_shift_hist}
\title{Plots chemical shift distribution}
\usage{
chemical_shift_hist(res = "*", atm = "*", type = "count", bw = 0.1,
  cutoff = 8, interactive = TRUE)
}
\arguments{
\item{res}{residue name in NMR-STAR atom nomenclature ; Example: ALA,GLY ; default '*' (includes everything)}

\item{atm}{atom name in NMR-STAR nomenclautre ; Example :CA,HB2 default '*' (includes all atoms)}

\item{type}{count ; other than count will assume density plot}

\item{bw}{binwith for histogram; default value 0.1ppm}

\item{cutoff}{values not with in the cutoff time standard deviation from both sides ofthe mean will be excluded from the plot;default value 8}

\item{interactive}{TRUE/FALSE default TRUE}
}
\value{
R plot object
}
\description{
Plots the histogram (or) density of  chemical shift distribution of a given amino acid (or) nucleic acid from BMRB database.  Optionally particular atom can be specified in the parameter
}
\examples{
#plt<-chemical_shift_hist('ALA')
#plots the histogram of all atoms of ALA
#plt<-chemical_shift_hist('GLY',type='density')
#plots the density plot
}
\seealso{
\code{\link{fetch_res_chemical_shifts}},\code{\link{filter_residue}} and \code{\link{chemical_shift_corr}}
}

