boto <- NULL

.onLoad <- function(libname, pkgname) {
  boto <<- reticulate::import("boto3", delay_load = T)
  register_s3_method("dplyr", "db_desc", "AthenaConnection")
  register_s3_method("dbplyr", "db_compute", "AthenaConnection")
  register_s3_method("dplyr", "db_save_query", "AthenaConnection")
  register_s3_method("dbplyr", "db_copy_to", "AthenaConnection")
  register_s3_method("dbplyr", "sql_translate_env", "AthenaConnection")
  
}

register_s3_method <- function(pkg, generic, class, fun = NULL) {
  stopifnot(is.character(pkg), length(pkg) == 1)
  stopifnot(is.character(generic), length(generic) == 1)
  stopifnot(is.character(class), length(class) == 1)
  
  if (is.null(fun)) {
    fun <- get(paste0(generic, ".", class), envir = parent.frame())
  } else {
    stopifnot(is.function(fun))
  }
  
  if (pkg %in% loadedNamespaces()) {
    registerS3method(generic, class, fun, envir = asNamespace(pkg))
  }
  
  # Always register hook in case package is later unloaded & reloaded
  setHook(
    packageEvent(pkg, "onLoad"),
    function(...) {
      registerS3method(generic, class, fun, envir = asNamespace(pkg))
    }
  )
}